/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.attachments;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class InAppChatPermissionsHelper {
    public static void checkPermission(@NonNull Context context, @NonNull String permission2, InAppChatPermissionAskListener listener) {
        if (InAppChatPermissionsHelper.shouldAskPermission(context, permission2)) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((AppCompatActivity)context), (String)permission2)) {
                listener.onNeedPermission(context, permission2);
            } else if (InAppChatPermissionsHelper.isFirstTimeAsking(context, permission2)) {
                InAppChatPermissionsHelper.setFirstTimeAsking(context, permission2, false);
                listener.onNeedPermission(context, permission2);
            } else {
                listener.onPermissionPreviouslyDeniedWithNeverAskAgain(context, permission2);
            }
        } else {
            listener.onPermissionGranted(context, permission2);
        }
    }

    public static boolean hasPermissionInManifest(@NonNull Context context, @NonNull String permissionName) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions == null) {
                return false;
            }
            for (String declaredPermission : declaredPermissions) {
                if (!declaredPermission.equals(permissionName)) continue;
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            MobileMessagingLogger.e((String)"[InAppChat] Package name not found", (Throwable)e);
        }
        return false;
    }

    private static boolean shouldAskPermission() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private static boolean shouldAskPermission(@NonNull Context context, @NonNull String permission2) {
        if (InAppChatPermissionsHelper.shouldAskPermission()) {
            int permissionResult = ActivityCompat.checkSelfPermission((Context)context, (String)permission2);
            return permissionResult != 0;
        }
        return false;
    }

    private static boolean isFirstTimeAsking(@NonNull Context context, @NonNull String permission2) {
        return PreferenceHelper.findBoolean((Context)context, (String)(MobileMessagingChatProperty.IN_APP_CHAT_PERMISSION_FIRST_TIME_ASK.getKey() + permission2), (boolean)true);
    }

    private static void setFirstTimeAsking(@NonNull Context context, @NonNull String permission2, Boolean isFirstTime) {
        PreferenceHelper.saveBoolean((Context)context, (String)(MobileMessagingChatProperty.IN_APP_CHAT_PERMISSION_FIRST_TIME_ASK.getKey() + permission2), (boolean)isFirstTime);
    }

    public static interface InAppChatPermissionAskListener {
        public void onNeedPermission(Context var1, String var2);

        public void onPermissionPreviouslyDeniedWithNeverAskAgain(Context var1, String var2);

        public void onPermissionGranted(Context var1, String var2);
    }
}

