/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.attachments;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.util.ArraySet;
import java.util.Set;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.attachments.InAppChatPermissionsHelper;

public class PermissionsRequestManager {
    private static final int IN_APP_CHAT_PERMISSIONS_REQUEST_CODE = 200;
    private static final int OPEN_SETTINGS_INTENT_CODE = 201;
    private Activity context;
    private PermissionsRequester permissionsRequester;

    public PermissionsRequestManager(Activity context, @NonNull PermissionsRequester permissionsRequester) {
        this.context = context;
        this.permissionsRequester = permissionsRequester;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 200 && this.isPermissionGranted(grantResults)) {
            this.permissionsRequester.onPermissionGranted();
        }
    }

    public boolean isRequiredPermissionsGranted() {
        ArraySet permissionsToAsk = new ArraySet();
        ArraySet neverAskPermissions = new ArraySet();
        for (String permission2 : this.permissionsRequester.requiredPermissions()) {
            if (!InAppChatPermissionsHelper.hasPermissionInManifest((Context)this.context, permission2)) {
                return false;
            }
            this.checkPermission(permission2, (Set<String>)permissionsToAsk, (Set<String>)neverAskPermissions);
        }
        if (neverAskPermissions.size() > 0) {
            this.showSettingsDialog((Set<String>)neverAskPermissions);
            return false;
        }
        String[] permissionsToAskArray = new String[permissionsToAsk.size()];
        permissionsToAsk.toArray(permissionsToAskArray);
        if (permissionsToAsk.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this.context, (String[])permissionsToAskArray, (int)200);
            return false;
        }
        return true;
    }

    private void checkPermission(String permission2, final Set<String> permissionsToAsk, final Set<String> neverAskPermissions) {
        InAppChatPermissionsHelper.checkPermission((Context)this.context, permission2, new InAppChatPermissionsHelper.InAppChatPermissionAskListener(){

            @Override
            public void onNeedPermission(Context context, String permission2) {
                permissionsToAsk.add(permission2);
            }

            @Override
            public void onPermissionPreviouslyDeniedWithNeverAskAgain(Context context, String permission2) {
                neverAskPermissions.add(permission2);
            }

            @Override
            public void onPermissionGranted(Context context, String permission2) {
            }
        });
    }

    private void showSettingsDialog(Set<String> permissions) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.context);
        builder.setTitle(R.string.ib_chat_permissions_not_granted_title).setMessage(R.string.ib_chat_permissions_not_granted_message).setPositiveButton(R.string.ib_chat_button_settings, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PermissionsRequestManager.this.openSettings();
            }
        }).setNegativeButton(R.string.mm_button_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).show();
    }

    private void openSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.context.getPackageName(), null);
        intent.setData(uri);
        this.context.startActivityForResult(intent, 201);
    }

    private boolean isPermissionGranted(@NonNull int[] grantResults) {
        return grantResults.length > 0 && grantResults[0] == 0;
    }

    public static interface PermissionsRequester {
        public void onPermissionGranted();

        @NonNull
        public String[] requiredPermissions();
    }
}

