/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import java.util.Date;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyIntentService;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class GeofencingConsistencyReceiver
extends BroadcastReceiver {
    public static final String NETWORK_PROVIDER_ENABLED_ACTION = "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED";
    public static final String SCHEDULED_GEO_REFRESH_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH";
    public static final String SCHEDULED_GEO_EXPIRE_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE";

    public void onReceive(Context context, Intent intent) {
        if (!GeofencingHelper.isGeoActivated(context)) {
            return;
        }
        String action = intent.getAction();
        if (StringUtils.isBlank((String)action)) {
            return;
        }
        switch (action) {
            case "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED": 
            case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH": 
            case "android.intent.action.TIME_SET": 
            case "android.intent.action.PACKAGE_DATA_CLEARED": 
            case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE": {
                GeofencingConsistencyIntentService.enqueueWork(context, intent);
            }
        }
    }

    public static void scheduleConsistencyAlarm(Context context, int alarmType, Date when, String action, int flags) {
        if (when == null) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        Intent intent = new Intent(context, GeofencingConsistencyReceiver.class);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
        alarmManager.set(alarmType, when.getTime(), pendingIntent);
    }
}

