/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.push;

import android.content.Context;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.storage.MessageStore;

public class PushMessageHandler {
    private static final String TAG = "Geofencing";

    public void handleGeoMessage(Context context, Message message) {
        GeofencingHelper geofencingHelper = new GeofencingHelper(context);
        MessageStore messageStoreForGeo = geofencingHelper.getMessageStoreForGeo();
        try {
            messageStoreForGeo.save(context, new Message[]{message});
            GeofencingHelper.setAllActiveGeoAreasMonitored(context, false);
            geofencingHelper.startGeoMonitoringIfNecessary();
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)TAG, (String)InternalSdkError.ERROR_SAVING_MESSAGE.get(), (Throwable)e);
        }
    }
}

