/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.report;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoLatLng;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.geo.mapper.GeoDataMapper;
import org.infobip.mobile.messaging.geo.report.GeoReport;
import org.infobip.mobile.messaging.geo.report.GeoReportingResult;
import org.infobip.mobile.messaging.geo.transition.GeoNotificationHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoReportHelper {
    @Nullable
    public static Message getSignalingMessageForReport(List<Message> messages, GeoReport report) {
        for (Message m : messages) {
            if (!m.getMessageId().equals(report.getSignalingMessageId())) continue;
            return m;
        }
        return null;
    }

    public static Map<Message, GeoEventType> createMessagesToNotify(Context context, List<GeoReport> reportedEvents, @NonNull GeoReportingResult reportingResult) {
        GeofencingHelper geofencingHelper = new GeofencingHelper(context);
        List allMessages = geofencingHelper.getMessageStoreForGeo().findAll(context);
        ArrayMap messages = new ArrayMap();
        for (GeoReport report : reportedEvents) {
            Message signalingMessage = GeoReportHelper.getSignalingMessageForReport(allMessages, report);
            if (signalingMessage == null) {
                MobileMessagingLogger.e((String)("Cannot find signaling message for id: " + report.getSignalingMessageId()));
                continue;
            }
            messages.put(GeoReportHelper.createNewMessageForReport(report, reportingResult, signalingMessage), report.getEvent());
        }
        return messages;
    }

    public static GeoReport[] createReportsForMultipleMessages(Context context, Map<Message, List<Area>> messagesAndAreas, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        ArrayList<GeoReport> reports = new ArrayList<GeoReport>();
        for (Message message : messagesAndAreas.keySet()) {
            reports.addAll(GeoReportHelper.createReports(context, message, messagesAndAreas.get(message), event, triggeringLocation));
        }
        return reports.toArray(new GeoReport[reports.size()]);
    }

    private static Set<GeoReport> createReports(Context context, Message signalingMessage, List<Area> areas, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        ArraySet reports = new ArraySet();
        for (Area area : areas) {
            GeoReport report = GeoReportHelper.createReport(signalingMessage, area, event, triggeringLocation);
            reports.add(report);
            MobileMessagingCore.getInstance((Context)context).addGeneratedMessageIds(new String[]{report.getMessageId()});
        }
        return reports;
    }

    @NonNull
    private static GeoReport createReport(Message signalingMessage, Area area, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        Geo geo = GeoDataMapper.geoFromInternalData(signalingMessage.getInternalData());
        return new GeoReport(geo == null ? "" : geo.getCampaignId(), UUID.randomUUID().toString(), signalingMessage.getMessageId(), event, area, Time.now(), triggeringLocation);
    }

    private static Message createNewMessageForReport(@NonNull GeoReport report, @NonNull GeoReportingResult reportingResult, @NonNull Message originalMessage) {
        Geo originalMessageGeo;
        GeoLatLng triggeringLocation = report.getTriggeringLocation();
        if (triggeringLocation == null) {
            triggeringLocation = new GeoLatLng(null, null);
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        if (report.getArea() != null) {
            areas.add(report.getArea());
        }
        Geo geo = (originalMessageGeo = GeoDataMapper.geoFromInternalData(originalMessage.getInternalData())) != null ? new Geo(triggeringLocation.getLat(), triggeringLocation.getLng(), originalMessageGeo.getDeliveryTime(), originalMessageGeo.getExpiryTime(), originalMessageGeo.getStartTime(), originalMessageGeo.getCampaignId(), areas, originalMessageGeo.getEvents(), originalMessage.getSentTimestamp(), originalMessage.getContentUrl()) : new Geo(triggeringLocation.getLat(), triggeringLocation.getLng(), null, null, null, null, areas, null, Time.now(), originalMessage.getContentUrl());
        String internalData = GeoDataMapper.geoToInternalData(geo);
        return new Message(GeoReportHelper.getMessageIdFromReport(report, reportingResult), originalMessage.getTitle(), originalMessage.getBody(), originalMessage.getSound(), originalMessage.isVibrate(), originalMessage.getIcon(), false, originalMessage.getCategory(), originalMessage.getFrom(), Time.now(), 0L, Time.now(), originalMessage.getCustomPayload(), internalData, originalMessage.getDestination(), originalMessage.getStatus(), originalMessage.getStatusMessage(), originalMessage.getContentUrl());
    }

    private static String getMessageIdFromReport(@NonNull GeoReport report, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return report.getMessageId();
        }
        String newMessageId = reportingResult.getMessageIds().get(report.getMessageId());
        if (newMessageId == null) {
            return report.getMessageId();
        }
        return newMessageId;
    }

    public static Set<String> getAndUpdateInactiveCampaigns(Context context, GeoReportingResult result) {
        ArraySet inactiveCampaigns = new ArraySet();
        if (result == null || result.hasError()) {
            inactiveCampaigns.addAll(GeofencingHelper.getSuspendedCampaignIds(context));
            inactiveCampaigns.addAll(GeofencingHelper.getFinishedCampaignIds(context));
            return inactiveCampaigns;
        }
        GeofencingHelper.addCampaignStatus(context, result.getFinishedCampaignIds(), result.getSuspendedCampaignIds());
        if (result.getFinishedCampaignIds() != null) {
            inactiveCampaigns.addAll(result.getFinishedCampaignIds());
        }
        if (result.getSuspendedCampaignIds() != null) {
            inactiveCampaigns.addAll(result.getSuspendedCampaignIds());
        }
        return inactiveCampaigns;
    }

    @NonNull
    public static Map<Message, List<Area>> findSignalingMessagesAndAreas(Context context, MessageStore messageStore, Set<String> requestIds, @NonNull GeoEventType event) {
        Date now = Time.date();
        ArrayMap messagesAndAreas = new ArrayMap();
        for (Message message : messageStore.findAll(context)) {
            Date startDate;
            Geo geo = GeoDataMapper.geoFromInternalData(message.getInternalData());
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty() || (startDate = geo.getStartDate()) != null && startDate.after(now)) continue;
            List<Area> campaignAreas = geo.getAreasList();
            ArrayList<Area> triggeredAreas = new ArrayList<Area>();
            for (Area area : campaignAreas) {
                for (String requestId : requestIds) {
                    if (!requestId.equalsIgnoreCase(area.getId()) || !GeoNotificationHelper.shouldReportTransition(context, geo, event)) continue;
                    triggeredAreas.add(area);
                }
            }
            if (triggeredAreas.isEmpty()) continue;
            messagesAndAreas.put(message, triggeredAreas);
        }
        return GeoReportHelper.filterOverlappingAreas((Map<Message, List<Area>>)messagesAndAreas);
    }

    public static List<GeoReport> filterOutNonActiveReports(Context context, @NonNull List<GeoReport> reports, @NonNull GeoReportingResult result) {
        if (result.hasError()) {
            return reports;
        }
        Set<String> inactiveCampaigns = GeoReportHelper.getAndUpdateInactiveCampaigns(context, result);
        if (inactiveCampaigns.isEmpty()) {
            return reports;
        }
        ArrayList<GeoReport> activeReports = new ArrayList<GeoReport>();
        for (GeoReport r : reports) {
            if (inactiveCampaigns.contains(r.getCampaignId())) continue;
            activeReports.add(r);
        }
        return activeReports;
    }

    public static Map<Message, List<Area>> filterOverlappingAreas(Map<Message, List<Area>> messagesAndAreas) {
        ArrayMap filteredMessagesAndAreas = new ArrayMap(messagesAndAreas.size());
        for (Map.Entry<Message, List<Area>> entry : messagesAndAreas.entrySet()) {
            Message message = entry.getKey();
            List<Area> areasList = entry.getValue();
            if (areasList == null) continue;
            Collections.sort(areasList, new GeoAreaRadiusComparator());
            filteredMessagesAndAreas.put(message, Collections.singletonList(areasList.get(0)));
        }
        return filteredMessagesAndAreas;
    }

    public static class GeoAreaRadiusComparator
    implements Comparator<Area> {
        @Override
        public int compare(Area area1, Area area2) {
            return area1.getRadius() - area2.getRadius();
        }
    }
}

