/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.transition;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.geo.platform.GeoBroadcaster;
import org.infobip.mobile.messaging.geo.report.GeoReport;
import org.infobip.mobile.messaging.geo.report.GeoReportHelper;
import org.infobip.mobile.messaging.geo.report.GeoReporter;
import org.infobip.mobile.messaging.geo.report.GeoReportingResult;
import org.infobip.mobile.messaging.geo.transition.GeoNotificationHelper;
import org.infobip.mobile.messaging.geo.transition.GeoTransition;
import org.infobip.mobile.messaging.geo.transition.GeoTransitionHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoAreasHandler {
    private static final String TAG = "GeofenceTransitions";
    private final MessageStore geoMessageStore;
    private final GeoNotificationHelper geoNotificationHelper;
    private final GeoReporter geoReporter;
    private final Context context;
    private final GeofencingHelper geofencingHelper;
    private final MobileMessagingCore mobileMessagingCore;

    GeoAreasHandler(Context context, GeoBroadcaster geoBroadcaster) {
        this.context = context;
        this.mobileMessagingCore = MobileMessagingCore.getInstance((Context)context);
        this.geoNotificationHelper = new GeoNotificationHelper(context, geoBroadcaster, (Broadcaster)new AndroidBroadcaster(context), this.mobileMessagingCore.getNotificationHandler());
        this.geoReporter = new GeoReporter(context, MobileMessagingCore.getInstance((Context)context), geoBroadcaster, MobileMessagingCore.getInstance((Context)context).getStats(), new MobileApiResourceProvider().getMobileApiGeo(context));
        this.geofencingHelper = new GeofencingHelper(context);
        this.geoMessageStore = this.geofencingHelper.getMessageStoreForGeo();
    }

    public GeoAreasHandler(Context context, MobileMessagingCore mobileMessagingCore, GeoNotificationHelper geoNotificationHelper, GeoReporter geoReporter, GeofencingHelper geofencingHelper) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.geoNotificationHelper = geoNotificationHelper;
        this.geoReporter = geoReporter;
        this.geofencingHelper = geofencingHelper;
        this.geoMessageStore = geofencingHelper.getMessageStoreForGeo();
    }

    void handleTransition(Intent intent) {
        GeoTransition transition;
        try {
            transition = GeoTransitionHelper.resolveTransitionFromIntent(intent);
        }
        catch (GeoTransitionHelper.GeofenceNotAvailableException e) {
            GeofencingHelper.setAllActiveGeoAreasMonitored(this.context, false);
            MobileMessagingLogger.e((String)TAG, (String)"Geofence not available");
            return;
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)TAG, (String)("Cannot resolve transition information: " + e));
            return;
        }
        this.handleTransition(transition);
    }

    public void handleTransition(GeoTransition transition) {
        MobileMessagingLogger.v((String)"GEO TRANSITION", (Object)transition);
        Map<Message, List<Area>> messagesAndAreas = GeoReportHelper.findSignalingMessagesAndAreas(this.context, this.geoMessageStore, transition.getRequestIds(), transition.getEventType());
        if (messagesAndAreas.isEmpty()) {
            MobileMessagingLogger.d((String)TAG, (String)"No messages for triggered areas");
            return;
        }
        GeoAreasHandler.logGeofences(messagesAndAreas.values(), transition.getEventType());
        this.geofencingHelper.addUnreportedGeoEvents(GeoReportHelper.createReportsForMultipleMessages(this.context, messagesAndAreas, transition.getEventType(), transition.getTriggeringLocation()));
        GeoReport[] unreportedEvents = this.geofencingHelper.removeUnreportedGeoEvents();
        if (unreportedEvents.length == 0) {
            MobileMessagingLogger.d((String)TAG, (String)"No geofencing events to report at current time");
            return;
        }
        try {
            GeoReportingResult result = this.geoReporter.reportSync(unreportedEvents);
            this.handleReportingResultWithNewMessagesAndNotifications(unreportedEvents, result);
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)TAG, (String)("Failed to report geo events " + e.toString()));
            GeoAreasHandler.handleGeoReportingResult(this.context, new GeoReportingResult(e));
        }
    }

    private void handleReportingResultWithNewMessagesAndNotifications(GeoReport[] unreportedEvents, GeoReportingResult result) {
        List<GeoReport> reports = GeoReportHelper.filterOutNonActiveReports(this.context, Arrays.asList(unreportedEvents), result);
        Map<Message, GeoEventType> messages = GeoReportHelper.createMessagesToNotify(this.context, reports, result);
        this.saveMessages(messages.keySet());
        GeoAreasHandler.handleGeoReportingResult(this.context, result);
        this.geoNotificationHelper.notifyAboutGeoTransitions(messages);
    }

    private void saveMessages(Collection<Message> generatedMessages) {
        if (!this.mobileMessagingCore.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = this.mobileMessagingCore.getMessageStore();
        messageStore.save(this.context, generatedMessages.toArray(new Message[generatedMessages.size()]));
    }

    public static void handleGeoReportingResult(Context context, @NonNull GeoReportingResult result) {
        GeoAreasHandler.updateMessageStoreWithReportingResult(context, result);
        GeoAreasHandler.updateUnreportedSeenMessageIds(context, result);
        if (!result.hasError()) {
            MobileMessagingCore.getInstance((Context)context).sync();
        }
    }

    private static void updateMessageStoreWithReportingResult(Context context, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return;
        }
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance((Context)context);
        if (!mobileMessagingCore.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = mobileMessagingCore.getMessageStore();
        List allMessages = messageStore.findAll(context);
        Map<String, String> messageIds = reportingResult.getMessageIds();
        for (Message message : allMessages) {
            String newMessageId = messageIds.get(message.getMessageId());
            if (newMessageId == null) continue;
            message.setMessageId(newMessageId);
        }
        messageStore.deleteAll(context);
        messageStore.save(context, allMessages.toArray(new Message[allMessages.size()]));
    }

    private static void updateUnreportedSeenMessageIds(Context context, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.hasError() || reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return;
        }
        MobileMessagingCore.getInstance((Context)context).updateUnreportedSeenMessageIds(reportingResult.getMessageIds());
        MobileMessagingCore.getInstance((Context)context).updatedGeneratedMessageIDs(reportingResult.getMessageIds());
    }

    private static void logGeofences(Collection<List<Area>> collection, @NonNull GeoEventType event) {
        for (List<Area> areas : collection) {
            for (Area a : areas) {
                MobileMessagingLogger.v((String)TAG, (String)(event.name().toUpperCase() + " (" + a.getTitle() + ") LAT:" + a.getLatitude() + " LON:" + a.getLongitude() + " RAD:" + a.getRadius()));
            }
        }
    }

    @VisibleForTesting
    public MobileMessagingCore getMobileMessagingCore() {
        return this.mobileMessagingCore;
    }
}

