/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import org.infobip.mobile.messaging.MobileMessagingJob;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.StringUtils;

public class GeofencingConsistencyIntentService
extends JobIntentService {
    public static final String NETWORK_PROVIDER_ENABLED_ACTION = "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED";
    public static final String SCHEDULED_GEO_REFRESH_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH";
    public static final String SCHEDULED_GEO_EXPIRE_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE";
    private GeofencingHelper geofencingHelper;

    public static void enqueueWork(Context context, Intent work) {
        GeofencingConsistencyIntentService.enqueueWork((Context)context, GeofencingConsistencyIntentService.class, (int)MobileMessagingJob.getScheduleId((Context)context, (int)4), (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        if (!GeofencingHelper.isGeoActivated((Context)this)) {
            return;
        }
        String action = intent.getAction();
        if (StringUtils.isBlank((String)action)) {
            return;
        }
        MobileMessagingLogger.i((String)String.format("[%s]", action));
        this.handleGeoConsistencyAction((Context)this, intent, action);
    }

    private void handleGeoConsistencyAction(Context context, Intent intent, String action) {
        switch (action) {
            case "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED": 
            case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH": 
            case "android.intent.action.TIME_SET": {
                this.startGeoMonitoringFromScratch(context);
                break;
            }
            case "android.intent.action.PACKAGE_DATA_CLEARED": {
                Uri data = intent.getData();
                if (data == null || !"com.google.android.gms".equals(data.getSchemeSpecificPart())) break;
                this.startGeoMonitoringFromScratch(context);
                break;
            }
            case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE": {
                this.geofencingHelper(context).removeExpiredAreas();
            }
        }
    }

    private void startGeoMonitoringFromScratch(Context context) {
        GeofencingHelper.setAllActiveGeoAreasMonitored(context, false);
        if (this.geofencingHelper(context).isLocationEnabled(context)) {
            this.geofencingHelper(context).startGeoMonitoringIfNecessary();
        }
    }

    public GeofencingHelper geofencingHelper(Context context) {
        if (this.geofencingHelper == null) {
            this.geofencingHelper = new GeofencingHelper(context);
        }
        return this.geofencingHelper;
    }
}

