/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.storage;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.geo.storage.SQLiteGeoMessage;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoSQLiteMessageStore
implements MessageStore {
    public void save(Context context, Message ... messages) {
        DatabaseHelper helper = MobileMessagingCore.getDatabaseHelper((Context)context);
        for (Message message : messages) {
            helper.save((DatabaseContract.DatabaseObject)new SQLiteGeoMessage(message));
        }
    }

    public List<Message> findAll(Context context) {
        return new ArrayList<Message>(MobileMessagingCore.getDatabaseHelper((Context)context).findAll(SQLiteGeoMessage.class));
    }

    public Message findById(Context context, String messageId) {
        return (Message)MobileMessagingCore.getDatabaseHelper((Context)context).find(SQLiteGeoMessage.class, messageId);
    }

    public long countAll(Context context) {
        return MobileMessagingCore.getDatabaseHelper((Context)context).countAll(SQLiteGeoMessage.class);
    }

    public void deleteAll(Context context) {
        MobileMessagingCore.getDatabaseHelper((Context)context).deleteAll(SQLiteGeoMessage.class);
    }

    public void deleteById(Context context, String messageId) {
        MobileMessagingCore.getDatabaseHelper((Context)context).delete(SQLiteGeoMessage.class, messageId);
    }

    public void deleteByIds(Context context, String[] messageIds) {
        MobileMessagingCore.getDatabaseHelper((Context)context).delete(SQLiteGeoMessage.class, messageIds);
    }
}

