/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.geofencing;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.util.Pair;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.cloud.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.BootReceiver;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoEnabledConsistencyReceiver;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyIntentService;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyReceiver;
import org.infobip.mobile.messaging.geo.geofencing.Geofencing;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.geo.mapper.GeoDataMapper;
import org.infobip.mobile.messaging.geo.storage.GeoSQLiteMessageStore;
import org.infobip.mobile.messaging.geo.transition.GeofenceTransitionsIntentService;
import org.infobip.mobile.messaging.geo.transition.GeofenceTransitionsReceiver;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.ComponentUtil;

public class GeofencingImpl
extends Geofencing
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG = "GeofencingImpl";
    private static GeofencingImpl instance;
    private final Context context;
    private static GeoEnabledConsistencyReceiver geoEnabledConsistencyReceiver;
    private final GeofencingHelper geofencingHelper;
    private final GoogleApiClient googleApiClient;
    private final MessageStore messageStore;
    private List<Geofence> geofences;
    private PendingIntent geofencePendingIntent;
    private GoogleApiClientRequestType requestType;

    private GeofencingImpl(Context context) {
        this.context = context;
        this.requestType = GoogleApiClientRequestType.NONE;
        this.geofences = new ArrayList<Geofence>();
        this.geofencingHelper = new GeofencingHelper(context);
        this.messageStore = this.geofencingHelper.getMessageStoreForGeo();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static GeofencingImpl getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = new GeofencingImpl(context);
        return instance;
    }

    static void scheduleRefresh(Context context) {
        GeofencingImpl.scheduleRefresh(context, new Date());
    }

    private static void scheduleRefresh(Context context, Date when) {
        if (when != null) {
            MobileMessagingLogger.i((String)TAG, (String)("Next refresh in " + when));
        }
        GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 0, when, "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH", 0);
    }

    private static void scheduleExpiry(Context context, Date when) {
        GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 0, when, "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE", 0);
    }

    void removeExpiredAreasFromStorage() {
        GeoSQLiteMessageStore messageStoreForGeo = (GeoSQLiteMessageStore)this.geofencingHelper.getMessageStoreForGeo();
        List<Message> messages = messageStoreForGeo.findAll(this.context);
        ArrayList<String> messageIdsToDelete = new ArrayList<String>(messages.size());
        Date now = new Date();
        for (Message message : messages) {
            Geo geo = GeoDataMapper.geoFromInternalData(message.getInternalData());
            if (geo == null) continue;
            List<Area> areasList = geo.getAreasList();
            Date expiryDate = geo.getExpiryDate();
            if (areasList == null || areasList.isEmpty()) continue;
            for (Area area : areasList) {
                if (!area.isValid() || expiryDate == null || !expiryDate.before(now)) continue;
                messageIdsToDelete.add(message.getMessageId());
            }
        }
        if (!messageIdsToDelete.isEmpty()) {
            messageStoreForGeo.deleteByIds(this.context, messageIdsToDelete.toArray(new String[0]));
        }
    }

    @VisibleForTesting
    public Pair<List<Geofence>, Pair<Date, Date>> calculateGeofencesToMonitorDates(MessageStore messageStore) {
        return this.calculateGeofencesToMonitorAndNextCheckDates(messageStore);
    }

    private Pair<List<Geofence>, Pair<Date, Date>> calculateGeofencesToMonitorAndNextCheckDates(MessageStore messageStore) {
        Date nextCheckRefreshDate = null;
        Date nextCheckExpireDate = null;
        HashMap<String, Geofence> geofences = new HashMap<String, Geofence>();
        HashMap<String, Date> expiryDates = new HashMap<String, Date>();
        List messages = messageStore.findAll(this.context);
        for (Message message : messages) {
            Geo geo = GeoDataMapper.geoFromInternalData(message.getInternalData());
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty()) continue;
            nextCheckExpireDate = GeofencingImpl.calculateNextCheckDateForGeoExpiry(geo, nextCheckExpireDate);
            Set<String> finishedCampaignIds = GeofencingHelper.getFinishedCampaignIds(this.context);
            if (finishedCampaignIds.contains(geo.getCampaignId())) continue;
            if (geo.isEligibleForMonitoring()) {
                List<Area> geoAreasList = geo.getAreasList();
                for (Area area : geoAreasList) {
                    Date expiry;
                    if (!area.isValid() || (expiry = (Date)expiryDates.get(area.getId())) != null && expiry.after(geo.getExpiryDate())) continue;
                    expiryDates.put(area.getId(), geo.getExpiryDate());
                    geofences.put(area.getId(), area.toGeofence(geo.getExpiryDate()));
                }
            }
            nextCheckRefreshDate = GeofencingImpl.calculateNextCheckDateForGeoStart(geo, nextCheckRefreshDate);
        }
        ArrayList geofenceList = new ArrayList(geofences.values());
        return new Pair(geofenceList, (Object)new Pair(nextCheckRefreshDate, nextCheckExpireDate));
    }

    private static Date calculateNextCheckDateForGeoStart(Geo geo, Date oldCheckDate) {
        Date now = new Date();
        Date expiryDate = geo.getExpiryDate();
        if (expiryDate != null && expiryDate.before(now)) {
            return oldCheckDate;
        }
        Date startDate = geo.getStartDate();
        if (startDate == null || startDate.before(now)) {
            return oldCheckDate;
        }
        if (oldCheckDate != null && oldCheckDate.before(startDate)) {
            return oldCheckDate;
        }
        return startDate;
    }

    private static Date calculateNextCheckDateForGeoExpiry(Geo geo, Date oldCheckDate) {
        Date now = new Date();
        Date expiryDate = geo.getExpiryDate();
        if (expiryDate == null) {
            if (oldCheckDate == null) {
                return null;
            }
            return oldCheckDate;
        }
        if (oldCheckDate != null && oldCheckDate.before(expiryDate)) {
            if (oldCheckDate.before(now)) {
                return now;
            }
            return oldCheckDate;
        }
        if (expiryDate.before(now)) {
            return now;
        }
        return expiryDate;
    }

    @Override
    public void startGeoMonitoring() {
        if (!PlayServicesSupport.isPlayServicesAvailable((Context)this.context) || !GeofencingHelper.isGeoActivated(this.context) || GeofencingHelper.areAllActiveGeoAreasMonitored(this.context)) {
            return;
        }
        if (!this.checkRequiredPermissions()) {
            return;
        }
        Pair<List<Geofence>, Pair<Date, Date>> tuple = this.calculateGeofencesToMonitorAndNextCheckDates(this.messageStore);
        Date nextRefreshDate = (Date)((Pair)tuple.second).first;
        Date nextExpireDate = (Date)((Pair)tuple.second).second;
        GeofencingImpl.scheduleRefresh(this.context, nextRefreshDate);
        GeofencingImpl.scheduleExpiry(this.context, nextExpireDate);
        this.geofences = (List)tuple.first;
        if (this.geofences.isEmpty()) {
            return;
        }
        this.requestType = GoogleApiClientRequestType.ADD_GEOFENCES;
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.addGeofences(this.googleApiClient, this.geofencingRequest(), this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                GeofencingImpl.this.logGeofenceStatus(status, true);
                GeofencingImpl.this.requestType = GoogleApiClientRequestType.NONE;
                GeofencingHelper.setAllActiveGeoAreasMonitored(GeofencingImpl.this.context, status.isSuccess());
            }
        });
    }

    @Override
    public void stopGeoMonitoring() {
        GeofencingHelper.setAllActiveGeoAreasMonitored(this.context, false);
        if (!this.checkRequiredPermissions()) {
            return;
        }
        this.requestType = GoogleApiClientRequestType.REMOVE_GEOFENCES;
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                GeofencingImpl.this.logGeofenceStatus(status, false);
                GeofencingImpl.this.requestType = GoogleApiClientRequestType.NONE;
            }
        });
    }

    @Override
    public void cleanup() {
        this.setGeoComponentsEnabledSettings(this.context, false);
        this.stopGeoMonitoring();
        this.messageStore.deleteAll(this.context);
    }

    @Override
    public void logoutUser() {
        this.stopGeoMonitoring();
        this.messageStore.deleteAll(this.context);
    }

    @Override
    public void setGeoComponentsEnabledSettings(Context context, boolean componentsStateEnabled) {
        ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, GeofenceTransitionsReceiver.class);
        ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, GeofenceTransitionsIntentService.class);
        ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, GeofencingConsistencyReceiver.class);
        ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, GeofencingConsistencyIntentService.class);
        ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, BootReceiver.class);
        if (Build.VERSION.SDK_INT <= 25) {
            ComponentUtil.setState((Context)context, (boolean)componentsStateEnabled, GeoEnabledConsistencyReceiver.class);
            return;
        }
        if (componentsStateEnabled) {
            if (null != geoEnabledConsistencyReceiver) {
                return;
            }
            geoEnabledConsistencyReceiver = new GeoEnabledConsistencyReceiver();
            IntentFilter intentFilter = new IntentFilter("android.location.PROVIDERS_CHANGED");
            context.registerReceiver((BroadcastReceiver)geoEnabledConsistencyReceiver, intentFilter);
        } else if (null != geoEnabledConsistencyReceiver) {
            context.unregisterReceiver((BroadcastReceiver)geoEnabledConsistencyReceiver);
            geoEnabledConsistencyReceiver = null;
        }
    }

    private boolean checkRequiredPermissions() {
        if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            MobileMessagingLogger.e((String)"Unable to configure geofencing", (String)new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.ACCESS_FINE_LOCATION").getMessage());
            return false;
        }
        return true;
    }

    private void logGeofenceStatus(@NonNull Status status, boolean activated) {
        if (status.isSuccess()) {
            MobileMessagingLogger.d((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activated successfully"));
        } else {
            MobileMessagingLogger.e((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activation failed: " + status.toString()));
        }
    }

    private GeofencingRequest geofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.geofences);
        return builder.build();
    }

    private PendingIntent geofencePendingIntent() {
        if (this.geofencePendingIntent == null) {
            Intent intent = new Intent(this.context, GeofenceTransitionsReceiver.class);
            this.geofencePendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
        }
        return this.geofencePendingIntent;
    }

    public void onConnected(@Nullable Bundle bundle) {
        MobileMessagingLogger.d((String)TAG, (String)"GoogleApiClient connected");
        if (GoogleApiClientRequestType.ADD_GEOFENCES.equals((Object)this.requestType)) {
            this.startGeoMonitoring();
        } else if (GoogleApiClientRequestType.REMOVE_GEOFENCES.equals((Object)this.requestType)) {
            this.stopGeoMonitoring();
        }
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        MobileMessagingLogger.e((String)TAG, (String)connectionResult.getErrorMessage(), (Throwable)new ConfigurationException(ConfigurationException.Reason.CHECK_LOCATION_SETTINGS));
    }

    private static enum GoogleApiClientRequestType {
        ADD_GEOFENCES,
        REMOVE_GEOFENCES,
        NONE;

    }
}

