/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infobip.mobile.messaging.dal.json.InternalDataMapper;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.DeliveryTime;
import org.infobip.mobile.messaging.geo.GeoEventSettings;
import org.infobip.mobile.messaging.geo.mapper.GeoBundleMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.ISO8601DateParseException;

public class Geo
extends InternalDataMapper.InternalData {
    private Double triggeringLatitude;
    private Double triggeringLongitude;
    private DeliveryTime deliveryTime;
    private String expiryTime;
    private String startTime;
    private String campaignId;
    private List<Area> geo = new ArrayList<Area>();
    private List<GeoEventSettings> event = new ArrayList<GeoEventSettings>();

    public Geo(Double triggeringLatitude, Double triggeringLongitude, DeliveryTime deliveryTime, String expiryTime, String startTime, String campaignId, List<Area> areasList, List<GeoEventSettings> eventSettings, long sentDateTime, String contentUrl) {
        super(sentDateTime, contentUrl);
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.deliveryTime = deliveryTime;
        this.expiryTime = expiryTime;
        this.startTime = startTime;
        this.campaignId = campaignId;
        this.geo = areasList;
        this.event = eventSettings;
    }

    public static Geo createFrom(Bundle bundle) {
        return GeoBundleMapper.geoFromBundle(bundle);
    }

    public Double getTriggeringLatitude() {
        return this.triggeringLatitude;
    }

    public Double getTriggeringLongitude() {
        return this.triggeringLongitude;
    }

    public List<Area> getAreasList() {
        return this.geo;
    }

    public List<GeoEventSettings> getEvents() {
        return this.event;
    }

    public Date getExpiryDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString((String)this.expiryTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e((String)("Cannot parse expiry date: " + e.getMessage()));
            MobileMessagingLogger.d((String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public boolean isEligibleForMonitoring() {
        Date now = new Date();
        return (this.getStartDate() == null || this.getStartDate().before(now)) && !this.isExpired();
    }

    public boolean isExpired() {
        Date now = new Date();
        Date expiryDate = this.getExpiryDate();
        return expiryDate != null && expiryDate.before(now);
    }

    public DeliveryTime getDeliveryTime() {
        return this.deliveryTime;
    }

    public Date getStartDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString((String)this.startTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e((String)("Cannot parse start date: " + e.getMessage()));
            MobileMessagingLogger.d((String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getExpiryTime() {
        return this.expiryTime;
    }

    public String getStartTime() {
        return this.startTime;
    }
}

