/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.Uri;
import android.support.v4.content.WakefulBroadcastReceiver;
import java.util.Date;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Time;

public class GeofencingConsistencyReceiver
extends WakefulBroadcastReceiver {
    public static final String NETWORK_PROVIDER_ENABLED_ACTION = "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED";
    public static final String SCHEDULED_GEO_REFRESH_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH";
    public static final String SCHEDULED_GEO_EXPIRE_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE";

    public void onReceive(Context context, Intent intent) {
        GeofencingHelper geofencingHelper = new GeofencingHelper(context);
        if (!GeofencingHelper.isActivated(context)) {
            return;
        }
        String action = intent.getAction();
        if (action != null) {
            MobileMessagingLogger.i((String)String.format("[%s]", action));
            LocationManager lm = (LocationManager)context.getSystemService("location");
            switch (action) {
                case "android.location.PROVIDERS_CHANGED": {
                    if (!lm.isProviderEnabled("network")) break;
                    Date triggerDate = new Date(Time.now() + 15000L);
                    GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 1, triggerDate, NETWORK_PROVIDER_ENABLED_ACTION, 0);
                    break;
                }
                case "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED": 
                case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH": 
                case "android.intent.action.TIME_SET": 
                case "android.intent.action.DATE_CHANGED": {
                    GeofencingHelper.setAllActiveGeoAreasMonitored(context, false);
                    if (!lm.isProviderEnabled("network")) break;
                    geofencingHelper.startGeoMonitoringIfNecessary();
                    break;
                }
                case "android.intent.action.PACKAGE_DATA_CLEARED": {
                    Uri data = intent.getData();
                    if (data == null || !"com.google.android.gms".equals(data.getSchemeSpecificPart())) break;
                    GeofencingHelper.setAllActiveGeoAreasMonitored(context, false);
                    if (!lm.isProviderEnabled("network")) break;
                    geofencingHelper.startGeoMonitoringIfNecessary();
                    break;
                }
                case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE": {
                    geofencingHelper.removeExpiredAreas();
                }
            }
        }
    }

    public static void scheduleConsistencyAlarm(Context context, int alarmType, Date when, String action, int flags) {
        if (when == null) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, GeofencingConsistencyReceiver.class);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
        alarmManager.set(alarmType, when.getTime(), pendingIntent);
    }
}

