/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.Context;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.geo.GeoReportSynchronization;
import org.infobip.mobile.messaging.geo.MobileGeo;
import org.infobip.mobile.messaging.geo.MobileMessagingGeoProperty;
import org.infobip.mobile.messaging.geo.geofencing.Geofencing;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.geo.push.PushMessageHandler;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class MobileGeoImpl
extends MobileGeo
implements MessageHandlerModule {
    private static MobileGeoImpl instance;
    private Context context;
    private Geofencing geofencing;

    public static MobileGeoImpl getInstance(Context context) {
        if (instance == null) {
            instance = (MobileGeoImpl)MobileMessagingCore.getInstance((Context)context).getGeoMessageHandlerModule();
        }
        return instance;
    }

    @Override
    public void activateGeofencing() {
        this.activateGeofencing(Geofencing.getInstance(this.context));
    }

    void activateGeofencing(Geofencing geofencing) {
        this.geofencing = geofencing;
        if (geofencing == null) {
            return;
        }
        GeofencingHelper.setActivated(this.context, true);
        geofencing.setGeoComponentsEnabledSettings(this.context, true);
        geofencing.startGeoMonitoring();
    }

    @Override
    public void deactivateGeofencing() {
        this.deactivateGeofencing(this.geofencing);
        this.geofencing = null;
    }

    void deactivateGeofencing(Geofencing geofencing) {
        if (geofencing == null) {
            geofencing = Geofencing.getInstance(this.context);
        }
        GeofencingHelper.setActivated(this.context, false);
        geofencing.setGeoComponentsEnabledSettings(this.context, false);
        geofencing.stopGeoMonitoring();
    }

    @Override
    public boolean isGeofencingActivated() {
        return GeofencingHelper.isActivated(this.context);
    }

    @Override
    public void cleanup() {
        this.deactivateGeofencing();
        Geofencing.getInstance(this.context).cleanup();
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingGeoProperty.ALL_ACTIVE_GEO_AREAS_MONITORED.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingGeoProperty.FINISHED_CAMPAIGN_IDS.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingGeoProperty.SUSPENDED_CAMPAIGN_IDS.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingGeoProperty.GEOFENCING_ACTIVATED.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingGeoProperty.UNREPORTED_GEO_EVENTS.getKey());
    }

    public void setContext(Context appContext) {
        this.context = appContext;
    }

    public void messageReceived(Message message) {
        if (MobileMessagingCore.hasGeo((Message)message)) {
            PushMessageHandler pushMessageHandler = new PushMessageHandler();
            pushMessageHandler.handleGeoMessage(this.context, message);
        }
    }

    public void applicationInForeground() {
        GeoReportSynchronization geoReportSynchronization = new GeoReportSynchronization(this.context);
        geoReportSynchronization.synchronize();
    }
}

