/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.platform;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.geo.GeoEvent;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoMessage;
import org.infobip.mobile.messaging.geo.mapper.GeoBundleMapper;
import org.infobip.mobile.messaging.geo.platform.GeoBroadcaster;
import org.infobip.mobile.messaging.geo.report.GeoReport;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;

public class AndroidGeoBroadcaster
implements GeoBroadcaster {
    private final Context context;
    private static Map<GeoEventType, GeoEvent> eventBroadcasts = new HashMap<GeoEventType, GeoEvent>(){
        {
            this.put(GeoEventType.entry, GeoEvent.GEOFENCE_AREA_ENTERED);
        }
    };

    public AndroidGeoBroadcaster(Context context) {
        this.context = context;
    }

    @Override
    public void geoEvent(@NonNull GeoEventType event, @NonNull GeoMessage geoMessage) {
        GeoEvent broadcastEvent = eventBroadcasts.get((Object)event);
        if (broadcastEvent == null) {
            return;
        }
        Intent geofenceIntent = this.prepareIntent(broadcastEvent);
        geofenceIntent.putExtras(GeoBundleMapper.geoMessageToBundle(geoMessage));
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(geofenceIntent);
        this.context.sendBroadcast(geofenceIntent);
    }

    @Override
    public void geoReported(@NonNull List<GeoReport> reports) {
        if (reports.isEmpty()) {
            return;
        }
        Intent geoReportsSent = this.prepareIntent(GeoEvent.GEOFENCE_EVENTS_REPORTED);
        geoReportsSent.putExtras(GeoBundleMapper.geoReportsToBundle(reports));
        this.context.sendBroadcast(geoReportsSent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(geoReportsSent);
    }

    @Override
    public void error(@NonNull MobileMessagingError error) {
        Intent reportingError = this.prepareErrorIntent(Event.API_COMMUNICATION_ERROR);
        reportingError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)error);
        this.context.sendBroadcast(reportingError);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(reportingError);
    }

    private Intent prepareIntent(GeoEvent event) {
        return new Intent(event.getKey()).setPackage(this.context.getPackageName());
    }

    private Intent prepareErrorIntent(Event event) {
        return new Intent(event.getKey()).setPackage(this.context.getPackageName());
    }
}

