/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.report;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.geo.EventReport;
import org.infobip.mobile.messaging.api.geo.EventReportBody;
import org.infobip.mobile.messaging.api.geo.EventReportResponse;
import org.infobip.mobile.messaging.api.geo.EventType;
import org.infobip.mobile.messaging.api.geo.MessagePayload;
import org.infobip.mobile.messaging.api.geo.MobileApiGeo;
import org.infobip.mobile.messaging.dal.json.InternalDataMapper;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.geo.platform.GeoBroadcaster;
import org.infobip.mobile.messaging.geo.report.GeoReport;
import org.infobip.mobile.messaging.geo.report.GeoReportHelper;
import org.infobip.mobile.messaging.geo.report.GeoReportingResult;
import org.infobip.mobile.messaging.geo.transition.GeoAreasHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.common.DefaultRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoReporter {
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final GeoBroadcaster broadcaster;
    private final GeofencingHelper geofenceHelper;
    private final MobileApiGeo mobileApiGeo;
    private final MRetryPolicy retryPolicy;

    public GeoReporter(Context context, MobileMessagingCore mobileMessagingCore, GeoBroadcaster broadcaster, MobileMessagingStats stats, MobileApiGeo mobileApiGeo) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.broadcaster = broadcaster;
        this.geofenceHelper = new GeofencingHelper(context);
        this.mobileApiGeo = mobileApiGeo;
        this.retryPolicy = DefaultRetryPolicy.create((Context)context);
    }

    public void synchronize() {
        Object[] reports = this.geofenceHelper.removeUnreportedGeoEvents();
        if (reports.length == 0 || !this.mobileMessagingCore.isPushRegistrationEnabled()) {
            return;
        }
        new MRetryableTask<GeoReport, GeoReportingResult>((GeoReport[])reports){
            final /* synthetic */ GeoReport[] val$reports;
            {
                this.val$reports = geoReportArray;
            }

            public GeoReportingResult run(GeoReport[] reports) {
                return GeoReporter.this.reportSync(reports);
            }

            public void after(GeoReportingResult geoReportingResult) {
                GeoReporter.this.handleSuccess(GeoReporter.this.context, this.val$reports, geoReportingResult);
                GeoAreasHandler.handleGeoReportingResult(GeoReporter.this.context, geoReportingResult);
            }

            public void error(Throwable error) {
                MobileMessagingLogger.e((String)"Error reporting geo areas!", (Throwable)error);
                GeoReporter.this.handleError(GeoReporter.this.context, error, this.val$reports);
                GeoAreasHandler.handleGeoReportingResult(GeoReporter.this.context, new GeoReportingResult(error));
            }
        }.retryWith(this.retryPolicy).execute(reports);
    }

    @NonNull
    public GeoReportingResult reportSync(@NonNull GeoReport[] geoReports) {
        EventReportBody eventReportBody = GeoReporter.prepareEventReportBody(this.context, this.geofenceHelper.getMessageStoreForGeo(), geoReports);
        MobileMessagingLogger.v((String)"GEO REPORT >>>", (Object)eventReportBody);
        EventReportResponse eventResponse = this.mobileApiGeo.report(eventReportBody);
        MobileMessagingLogger.v((String)"GEO REPORT <<<", (Object)eventResponse);
        GeoReportingResult result = new GeoReportingResult(eventResponse);
        this.handleSuccess(this.context, geoReports, result);
        return result;
    }

    private void handleSuccess(Context context, GeoReport[] geoReports, GeoReportingResult result) {
        List<GeoReport> geoReportsToBroadcast = GeoReportHelper.filterOutNonActiveReports(context, Arrays.asList(geoReports), result);
        this.broadcaster.geoReported(geoReportsToBroadcast);
    }

    private void handleError(Context context, Throwable error, GeoReport[] geoReports) {
        MobileMessagingLogger.e((String)("Error reporting geo areas: " + error));
        MobileMessagingCore.getInstance((Context)context).setLastHttpException(error);
        this.stats.reportError(MobileMessagingStatsError.GEO_REPORTING_ERROR);
        this.geofenceHelper.addUnreportedGeoEvents(geoReports);
        this.broadcaster.error(MobileMessagingError.createFrom((Throwable)error));
    }

    @NonNull
    private static EventReportBody prepareEventReportBody(Context context, MessageStore geoMessageStore, @NonNull GeoReport[] geoReports) {
        HashSet<MessagePayload> messagePayloads = new HashSet<MessagePayload>();
        HashSet<EventReport> eventReports = new HashSet<EventReport>();
        List messages = geoMessageStore.findAll(context);
        for (GeoReport r : geoReports) {
            Message m = GeoReportHelper.getSignalingMessageForReport(messages, r);
            if (m == null) {
                MobileMessagingLogger.e((String)("Cannot find signaling message for id: " + r.getSignalingMessageId()));
                continue;
            }
            messagePayloads.add(new MessagePayload(m.getMessageId(), m.getTitle(), m.getBody(), m.getSound(), Boolean.valueOf(m.isVibrate()), m.getCategory(), Boolean.valueOf(m.isSilent()), m.getCustomPayload() != null ? m.getCustomPayload().toString() : null, InternalDataMapper.createInternalDataBasedOnMessageContents((Message)m)));
            Long timestampDelta = Time.now() - r.getTimestampOccurred();
            Long timestampDeltaSeconds = TimeUnit.MILLISECONDS.toSeconds(timestampDelta);
            eventReports.add(new EventReport(EventType.valueOf((String)r.getEvent().name()), r.getArea().getId(), r.getCampaignId(), r.getSignalingMessageId(), r.getMessageId(), timestampDeltaSeconds));
        }
        String deviceInstanceId = MobileMessagingCore.getInstance((Context)context).getPushRegistrationId();
        return new EventReportBody(messagePayloads, eventReports, deviceInstanceId);
    }
}

