/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.transition;

import android.content.Intent;
import android.location.Location;
import android.support.v4.util.ArraySet;
import android.util.SparseArray;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofenceStatusCodes;
import com.google.android.gms.location.GeofencingEvent;
import java.util.Set;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoLatLng;
import org.infobip.mobile.messaging.geo.transition.GeoTransition;

class GeoTransitionHelper {
    private static SparseArray<GeoEventType> supportedTransitionEvents = new SparseArray<GeoEventType>(){
        {
            this.put(1, (Object)GeoEventType.entry);
        }
    };

    GeoTransitionHelper() {
    }

    static GeoTransition resolveTransitionFromIntent(Intent intent) throws RuntimeException {
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent == null) {
            throw new RuntimeException("Geofencing event is null, cannot process");
        }
        if (geofencingEvent.hasError()) {
            if (geofencingEvent.getErrorCode() == 1000) {
                throw new GeofenceNotAvailableException();
            }
            throw new RuntimeException("ERROR: " + GeofenceStatusCodes.getStatusCodeString((int)geofencingEvent.getErrorCode()));
        }
        GeoEventType event = (GeoEventType)((Object)supportedTransitionEvents.get(geofencingEvent.getGeofenceTransition()));
        if (event == null) {
            throw new RuntimeException("Transition is not supported: " + geofencingEvent.getGeofenceTransition());
        }
        ArraySet triggeringRequestIds = new ArraySet();
        for (Geofence geofence : geofencingEvent.getTriggeringGeofences()) {
            triggeringRequestIds.add(geofence.getRequestId());
        }
        Location location = geofencingEvent.getTriggeringLocation();
        return new GeoTransition(event, (Set<String>)triggeringRequestIds, new GeoLatLng(location.getLatitude(), location.getLongitude()));
    }

    static class GeofenceNotAvailableException
    extends RuntimeException {
        GeofenceNotAvailableException() {
        }
    }
}

