/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import java.util.Date;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyReceiver;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingHelper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.util.StringUtils;

public class GeoEnabledConsistencyReceiver
extends BroadcastReceiver {
    private GeofencingHelper geofencingHelper;

    public GeoEnabledConsistencyReceiver() {
    }

    @VisibleForTesting
    GeoEnabledConsistencyReceiver(GeofencingHelper geofencingHelper) {
        this.geofencingHelper = geofencingHelper;
    }

    public void onReceive(Context context, Intent intent) {
        if (!GeofencingHelper.isGeoActivated(context)) {
            return;
        }
        String action = intent.getAction();
        if (StringUtils.isBlank((String)action)) {
            return;
        }
        MobileMessagingLogger.i((String)String.format("[%s]", action));
        if ("android.location.PROVIDERS_CHANGED".equals(action) && this.geofencingHelper(context).isLocationEnabled(context)) {
            Date triggerDate = new Date(Time.now() + 15000L);
            GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 1, triggerDate, "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED", 0);
        }
    }

    public GeofencingHelper geofencingHelper(Context context) {
        if (this.geofencingHelper == null) {
            this.geofencingHelper = new GeofencingHelper(context);
        }
        return this.geofencingHelper;
    }
}

