/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo.geofencing;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.util.ArraySet;
import java.util.HashSet;
import java.util.Set;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.geo.MobileMessagingGeoProperty;
import org.infobip.mobile.messaging.geo.geofencing.GeofencingImpl;
import org.infobip.mobile.messaging.geo.report.GeoReport;
import org.infobip.mobile.messaging.geo.storage.GeoSQLiteMessageStore;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class GeofencingHelper {
    private final Context context;
    private GeoSQLiteMessageStore internalStoreForGeo;
    private final JsonSerializer serializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);

    public GeofencingHelper(Context context) {
        this.context = context;
    }

    @NonNull
    public MessageStore getMessageStoreForGeo() {
        if (this.internalStoreForGeo == null) {
            this.internalStoreForGeo = new GeoSQLiteMessageStore();
        }
        return this.internalStoreForGeo;
    }

    public GeoReport[] removeUnreportedGeoEvents() {
        return (GeoReport[])PreferenceHelper.runTransaction((PreferenceHelper.Transaction)new PreferenceHelper.Transaction<GeoReport[]>(){

            public GeoReport[] run() {
                String[] unreportedGeoEventsJsons = PreferenceHelper.findStringArray((Context)GeofencingHelper.this.context, (String)MobileMessagingGeoProperty.UNREPORTED_GEO_EVENTS.getKey(), (String[])new String[0]);
                HashSet<GeoReport> reports = new HashSet<GeoReport>();
                for (String unreportedGeoEventJson : unreportedGeoEventsJsons) {
                    try {
                        GeoReport report = (GeoReport)GeofencingHelper.this.serializer.deserialize(unreportedGeoEventJson, GeoReport.class);
                        reports.add(report);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                PreferenceHelper.remove((Context)GeofencingHelper.this.context, (String)MobileMessagingGeoProperty.UNREPORTED_GEO_EVENTS.getKey());
                return reports.toArray(new GeoReport[0]);
            }
        });
    }

    public void addUnreportedGeoEvents(final GeoReport ... reports) {
        PreferenceHelper.runTransaction((PreferenceHelper.Transaction)new PreferenceHelper.Transaction<Void>(){

            public Void run() {
                for (GeoReport report : reports) {
                    PreferenceHelper.appendToStringArray((Context)GeofencingHelper.this.context, (String)MobileMessagingGeoProperty.UNREPORTED_GEO_EVENTS.getKey(), (String[])new String[]{GeofencingHelper.this.serializer.serialize((Object)report)});
                }
                return null;
            }
        });
    }

    public void removeExpiredAreas() {
        if (GeofencingHelper.isGeoActivated(this.context) && MobileMessagingCore.getInstance((Context)this.context).isPushRegistrationEnabled()) {
            GeofencingImpl.getInstance(this.context).removeExpiredAreasFromStorage();
        }
    }

    public void startGeoMonitoringIfNecessary() {
        if (GeofencingHelper.isGeoActivated(this.context) && MobileMessagingCore.getInstance((Context)this.context).isPushRegistrationEnabled()) {
            GeofencingImpl.getInstance(this.context).startGeoMonitoring();
        }
    }

    public static void addCampaignStatus(final Context context, final Set<String> finishedCampaignIds, final Set<String> suspendedCampaignIds) {
        PreferenceHelper.runTransaction((PreferenceHelper.Transaction)new PreferenceHelper.Transaction<Void>(){

            public Void run() {
                PreferenceHelper.saveStringSet((Context)context, (String)MobileMessagingGeoProperty.FINISHED_CAMPAIGN_IDS.getKey(), (Set)(finishedCampaignIds != null ? finishedCampaignIds : new ArraySet()));
                PreferenceHelper.saveStringSet((Context)context, (String)MobileMessagingGeoProperty.SUSPENDED_CAMPAIGN_IDS.getKey(), (Set)(suspendedCampaignIds != null ? suspendedCampaignIds : new ArraySet()));
                return null;
            }
        });
    }

    public void handleBootCompleted() {
        GeofencingHelper.setAllActiveGeoAreasMonitored(this.context, false);
        GeofencingImpl.scheduleRefresh(this.context);
    }

    public boolean isLocationEnabled(Context context) {
        if (this.isKitKatOrAbove()) {
            try {
                return this.isLocationModeOn(context) || this.isNetworkProviderAvailable(context);
            }
            catch (Settings.SettingNotFoundException e) {
                return this.isNetworkProviderAvailable(context);
            }
        }
        return this.isNetworkProviderAvailable(context);
    }

    public boolean isKitKatOrAbove() {
        return Build.VERSION.SDK_INT >= 19;
    }

    @TargetApi(value=19)
    public boolean isLocationModeOn(Context context) throws Settings.SettingNotFoundException {
        int locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
        return locationMode != 0;
    }

    public boolean isNetworkProviderAvailable(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm != null && lm.isProviderEnabled("network");
    }

    public static Set<String> getFinishedCampaignIds(Context context) {
        return PreferenceHelper.findStringSet((Context)context, (String)MobileMessagingGeoProperty.FINISHED_CAMPAIGN_IDS.getKey(), (Set)new ArraySet());
    }

    public static Set<String> getSuspendedCampaignIds(Context context) {
        return PreferenceHelper.findStringSet((Context)context, (String)MobileMessagingGeoProperty.SUSPENDED_CAMPAIGN_IDS.getKey(), (Set)new ArraySet());
    }

    public static void setGeoActivated(Context context, boolean activated) {
        PreferenceHelper.saveBoolean((Context)context, (MobileMessagingProperty)MobileMessagingProperty.GEOFENCING_ACTIVATED, (boolean)activated);
    }

    public static boolean isGeoActivated(Context context) {
        return PreferenceHelper.findBoolean((Context)context, (String)MobileMessagingProperty.GEOFENCING_ACTIVATED.getKey(), (boolean)false);
    }

    static boolean areAllActiveGeoAreasMonitored(Context context) {
        return PreferenceHelper.findBoolean((Context)context, (String)MobileMessagingGeoProperty.ALL_ACTIVE_GEO_AREAS_MONITORED.getKey(), (boolean)false);
    }

    public static void setAllActiveGeoAreasMonitored(Context context, boolean allActiveGeoAreasMonitored) {
        PreferenceHelper.saveBoolean((Context)context, (String)MobileMessagingGeoProperty.ALL_ACTIVE_GEO_AREAS_MONITORED.getKey(), (boolean)allActiveGeoAreasMonitored);
    }
}

