/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=11)
public class MobileMessaging {
    public static final String TAG = "MobileMessaging";
    private static MobileMessaging instance;
    private final Context context;

    private MobileMessaging(Context context) {
        this.context = context;
    }

    public static synchronized MobileMessaging getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        instance = new MobileMessaging(context);
        return instance;
    }

    public void setMessagesDelivered(String ... messageIds) {
        MobileMessagingCore.getInstance(this.context).setMessagesDelivered(messageIds);
    }

    public long getMsisdn() {
        return MobileMessagingCore.getInstance(this.context).getMsisdn();
    }

    public void setMsisdn(long msisdn) {
        MobileMessagingCore.getInstance(this.context).setMsisdn(msisdn);
    }

    public void setMessagesSeen(String ... messageIds) {
        MobileMessagingCore.getInstance(this.context).setMessagesSeen(messageIds);
    }

    public MessageStore getMessageStore() {
        return MobileMessagingCore.getInstance(this.context).getMessageStore();
    }

    public static final class Builder {
        private final Application application;
        private String gcmSenderId = (String)MobileMessagingProperty.GCM_SENDER_ID.getDefaultValue();
        private String applicationCode = (String)MobileMessagingProperty.APPLICATION_CODE.getDefaultValue();
        private String apiUri = (String)MobileMessagingProperty.API_URI.getDefaultValue();
        private NotificationSettings notificationSettings = null;
        private boolean reportCarrierInfo = true;
        private boolean reportSystemInfo = true;
        private Class<? extends MessageStore> messageStoreClass = (Class)MobileMessagingProperty.MESSAGE_STORE_CLASS.getDefaultValue();

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application object is mandatory!");
            }
            this.application = application;
            this.loadDefaultApiUri((Context)application);
            this.loadGcmSenderId((Context)application);
            this.loadApplicationCode((Context)application);
            this.loadNotificationSettings((Context)application);
        }

        private void loadNotificationSettings(Context context) {
            boolean displayNotificationEnabled = (Boolean)MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED.getDefaultValue();
            if (!displayNotificationEnabled) {
                return;
            }
            this.notificationSettings = new NotificationSettings.Builder(context).build();
        }

        private void loadDefaultApiUri(Context context) {
            String apiUri;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_api_uri");
            if (resource > 0 && StringUtils.isNotBlank(apiUri = context.getResources().getString(resource))) {
                this.apiUri = apiUri;
            }
        }

        private void loadGcmSenderId(Context context) {
            String gcmSenderId;
            int resource = ResourceLoader.loadResourceByName(context, "string", "google_app_id");
            if (resource > 0 && StringUtils.isNotBlank(gcmSenderId = context.getResources().getString(resource))) {
                this.gcmSenderId = gcmSenderId;
            }
        }

        private void loadApplicationCode(Context context) {
            String applicationCode;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_application_code");
            if (resource > 0 && StringUtils.isNotBlank(applicationCode = context.getResources().getString(resource))) {
                this.applicationCode = applicationCode;
            }
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withGcmSenderId(String gcmSenderId) {
            this.validateWithParam(gcmSenderId);
            this.gcmSenderId = gcmSenderId;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withApiUri(String apiUri) {
            this.validateWithParam(apiUri);
            this.apiUri = apiUri;
            return this;
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.validateWithParam(notificationSettings);
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withoutDisplayNotification() {
            this.notificationSettings = null;
            return this;
        }

        public Builder withMessageStore(Class<? extends MessageStore> messageStoreClass) {
            this.validateWithParam(messageStoreClass);
            this.messageStoreClass = messageStoreClass;
            return this;
        }

        public Builder withoutMessageStore() {
            this.messageStoreClass = null;
            return this;
        }

        public Builder withoutCarrierInfo() {
            this.reportCarrierInfo = false;
            return this;
        }

        public Builder withoutSystemInfo() {
            this.reportSystemInfo = false;
            return this;
        }

        public MobileMessaging build() {
            MobileMessagingCore.setApiUri((Context)this.application, this.apiUri);
            MobileMessagingCore.setGcmSenderId((Context)this.application, this.gcmSenderId);
            MobileMessagingCore.setMessageStoreClass((Context)this.application, this.messageStoreClass);
            MobileMessagingCore.setReportCarrierInfo((Context)this.application, this.reportCarrierInfo);
            MobileMessagingCore.setReportSystemInfo((Context)this.application, this.reportSystemInfo);
            MobileMessaging mobileMessaging = new MobileMessaging((Context)this.application);
            instance = mobileMessaging;
            new MobileMessagingCore.Builder(this.application).withDisplayNotification(this.notificationSettings).withApplicationCode(this.applicationCode).build();
            return mobileMessaging;
        }
    }
}

