/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.infobip.mobile.messaging.DeliveryReporter;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.MsisdnSynchronizer;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.RegistrationSynchronizer;
import org.infobip.mobile.messaging.SeenStatusReporter;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileMessagingCore {
    private static MobileMessagingCore instance;
    private final RegistrationSynchronizer registrationSynchronizer = new RegistrationSynchronizer();
    private final DeliveryReporter deliveryReporter = new DeliveryReporter();
    private final SeenStatusReporter seenStatusReporter = new SeenStatusReporter();
    private final MsisdnSynchronizer msisdnSynchronizer = new MsisdnSynchronizer();
    private final MobileNetworkStateListener mobileNetworkStateListener;
    private final MobileMessagingStats stats;
    private final PlayServicesSupport playServicesSupport = new PlayServicesSupport();
    private final Executor taskExecutor = Executors.newSingleThreadExecutor();
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private Context context;
    private SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (MobileMessagingProperty.MSISDN_TO_REPORT.getKey().equals(key) && PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.MSISDN_TO_REPORT)) {
                MobileMessagingCore.this.sync();
            }
        }
    };

    protected MobileMessagingCore(Context context) {
        this.context = context;
        this.stats = new MobileMessagingStats(context);
        this.mobileNetworkStateListener = new MobileNetworkStateListener(context);
        this.activityLifecycleMonitor = null;
        PreferenceHelper.registerOnSharedPreferenceChangeListener(context, this.onSharedPreferenceChangeListener);
    }

    public static MobileMessagingCore getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        instance = new MobileMessagingCore(context);
        return instance;
    }

    public void sync() {
        this.registrationSynchronizer.syncronize(this.context, this.getDeviceApplicationInstanceId(), this.getRegistrationId(), this.isRegistrationIdReported(), this.getStats(), this.taskExecutor);
        this.deliveryReporter.report(this.context, this.getUnreportedMessageIds(), this.getStats(), this.taskExecutor);
        this.seenStatusReporter.report(this.context, this.getUnreportedSeenMessageIds(), this.getStats(), this.taskExecutor);
        this.msisdnSynchronizer.syncronize(this.context, this.getUnreportedMsisdn(), this.isMsisdnReported(), this.getStats(), this.taskExecutor);
    }

    public long getMsisdn() {
        return PreferenceHelper.findLong(this.context, MobileMessagingProperty.MSISDN);
    }

    public long getUnreportedMsisdn() {
        return PreferenceHelper.findLong(this.context, MobileMessagingProperty.MSISDN_TO_REPORT);
    }

    protected void setMsisdn(long msisdn) {
        if (msisdn < 0L) {
            throw new IllegalArgumentException("MSISDN can't be negative!");
        }
        long oldMsisdn = this.getMsisdn();
        if (oldMsisdn != 0L && oldMsisdn == msisdn) {
            this.setMsisdnReported(false);
            return;
        }
        PreferenceHelper.saveLong(this.context, MobileMessagingProperty.MSISDN_TO_REPORT, msisdn);
    }

    protected boolean isMsisdnReported() {
        return !PreferenceHelper.contains(this.context, MobileMessagingProperty.MSISDN_TO_REPORT);
    }

    public void setMsisdnReported(boolean success) {
        long reportedMsisdn = PreferenceHelper.findLong(this.context, MobileMessagingProperty.MSISDN_TO_REPORT);
        if (success && reportedMsisdn > 0L) {
            PreferenceHelper.saveLong(this.context, MobileMessagingProperty.MSISDN, reportedMsisdn);
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.MSISDN_TO_REPORT);
    }

    public String getRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID);
    }

    public String getDeviceApplicationInstanceId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    public String[] getUnreportedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    protected void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void removeUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public String[] getUnreportedSeenMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
    }

    protected void addUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    public void setMessagesDelivered(String ... messageIds) {
        this.addUnreportedMessageIds(messageIds);
        this.sync();
    }

    protected void setMessagesSeen(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.sync();
    }

    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    protected static void setGcmSenderId(Context context, String gcmSenderId) {
        if (StringUtils.isBlank(gcmSenderId)) {
            throw new IllegalArgumentException("gcmSenderId is mandatory! Get one here: https://developers.google.com/mobile/add?platform=android&cntapi=gcm");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.GCM_SENDER_ID, gcmSenderId);
    }

    public String getGcmSenderId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.registrationSynchronizer.isRegistrationIdReported(this.context);
    }

    private void setRegistrationIdReported(boolean registrationIdReported) {
        this.registrationSynchronizer.setRegistrationIdReported(this.context, registrationIdReported);
    }

    public void setRegistrationId(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID, registrationId);
        this.setRegistrationIdReported(false);
    }

    protected static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    protected MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Exception lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (StringUtils.isBlank(applicationCode)) {
            throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
    }

    public static String getApplicationCode(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
    }

    protected static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public String getApiUri() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.API_URI);
    }

    protected static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    protected static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    private static void cleanup(Context context) {
        String gcmSenderID = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
        String gcmToken = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        Intent intent = new Intent("org.infobip.mobile.messaging.gcm.token.cleanup", null, context, MobileMessagingGcmIntentService.class);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_SENDER_ID", gcmSenderID);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_TOKEN", gcmToken);
        context.startService(intent);
        PreferenceHelper.remove(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.MSISDN_TO_REPORT);
        PreferenceHelper.remove(context, MobileMessagingProperty.MSISDN);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
    }

    public static final class Builder {
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private final Application application;

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application is mandatory!");
            }
            this.application = application;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public MobileMessagingCore build() {
            if (!this.applicationCode.equals(MobileMessagingCore.getApplicationCode((Context)this.application))) {
                MobileMessagingCore.cleanup((Context)this.application);
            }
            MobileMessagingCore mobileMessagingCore = new MobileMessagingCore((Context)this.application);
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            instance = mobileMessagingCore;
            mobileMessagingCore.activityLifecycleMonitor = new ActivityLifecycleMonitor(this.application);
            mobileMessagingCore.playServicesSupport.checkPlayServices((Context)this.application);
            return mobileMessagingCore;
        }
    }
}

