/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.RegisterMsisdnResult;
import org.infobip.mobile.messaging.tasks.RegisterMsisdnTask;

class MsisdnSynchronizer {
    MsisdnSynchronizer() {
    }

    void syncronize(final Context context, final long msisdn, boolean msisdnReported, final MobileMessagingStats stats, Executor executor) {
        if (msisdn <= 0L) {
            MobileMessagingCore.getInstance(context).setMsisdnReported(false);
            return;
        }
        new RegisterMsisdnTask(context){

            protected void onPostExecute(RegisterMsisdnResult registerMsisdnResult) {
                if (null == registerMsisdnResult) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API didn't return any value!");
                    stats.reportError(MobileMessagingError.MSISDN_SYNC_ERROR);
                    Intent msisdnReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    context.sendBroadcast(msisdnReportError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(msisdnReportError);
                    return;
                }
                MobileMessagingCore.getInstance(context).setMsisdnReported(true);
                Intent msisdnSynced = new Intent(Event.MSISDN_SYNCED.getKey());
                msisdnSynced.putExtra("org.infobip.mobile.messaging.msisdn", msisdn);
                context.sendBroadcast(msisdnSynced);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(msisdnSynced);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error reporting MSISDN!");
                stats.reportError(MobileMessagingError.MSISDN_SYNC_ERROR);
            }
        }.executeOnExecutor(executor, new Object[0]);
    }
}

