/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SeenStatusReportResult;
import org.infobip.mobile.messaging.tasks.SeenStatusReportTask;

public class SeenStatusReporter {
    void report(final Context context, String[] unreportedSeenMessageIds, final MobileMessagingStats stats, Executor executor) {
        if (unreportedSeenMessageIds.length == 0) {
            return;
        }
        new SeenStatusReportTask(context){

            protected void onPostExecute(SeenStatusReportResult result) {
                if (null == result) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API didn't return any value!");
                    stats.reportError(MobileMessagingError.SEEN_REPORTING_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationSaveError);
                    return;
                }
                Intent seenReportsSent = new Intent(Event.SEEN_REPORTS_SENT.getKey());
                Bundle extras = new Bundle();
                extras.putStringArray("org.infobip.mobile.messaging.message.ids", result.getMessageIDs());
                seenReportsSent.putExtras(extras);
                context.sendBroadcast(seenReportsSent);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenReportsSent);
            }

            protected void onCancelled() {
                stats.reportError(MobileMessagingError.SEEN_REPORTING_ERROR);
                Log.e((String)"MobileMessaging", (String)"Error reporting seen status!");
            }
        }.executeOnExecutor(executor, new Object[0]);
    }
}

