/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

class MobileMessageHandler {
    MobileMessageHandler() {
    }

    void handleNotification(Context context, Intent intent) {
        String from = intent.getStringExtra("from");
        Bundle data = intent.getExtras();
        data.putLong("received_timestamp", System.currentTimeMillis());
        Log.d((String)"MobileMessaging", (String)("Message received from: " + from));
        Message message = this.createMessage(from, data);
        this.sendDeliveryReport(context, message);
        Log.d((String)"MobileMessaging", (String)("Message is silent: " + message.isSilent()));
        if (!message.isSilent()) {
            this.saveMessage(context, message);
            this.displayNotification(context, message);
        }
        Intent messageReceived = new Intent(Event.MESSAGE_RECEIVED.getKey());
        messageReceived.putExtras(message.getBundle());
        context.sendBroadcast(messageReceived);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageReceived);
    }

    private void saveMessage(Context context, Message message) {
        if (!MobileMessagingCore.getInstance(context).isMessageStoreEnabled()) {
            Log.d((String)"MobileMessaging", (String)("Skipping save message: " + message.getMessageId()));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Saving message: " + message.getMessageId()));
        try {
            MobileMessagingCore.getInstance(context).getMessageStore().save(context, message);
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)("Error saving message: " + message.getMessageId()), (Throwable)e);
        }
    }

    private Message createMessage(String from, Bundle data) {
        Message message = Message.copyFrom(data);
        message.setFrom(from);
        message.setData(data);
        return message;
    }

    private void sendDeliveryReport(Context context, Message message) {
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.e((String)"MobileMessaging", (String)("No ID received for message: " + message));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Sending DR: " + message.getMessageId()));
        MobileMessagingCore.getInstance(context).setMessagesDelivered(message.getMessageId());
    }

    private void displayNotification(Context context, Message message) {
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(context).getNotificationSettings();
        if (null == notificationSettings) {
            return;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return;
        }
        if (StringUtils.isBlank(message.getBody())) {
            return;
        }
        if (ActivityLifecycleMonitor.isForeground() && notificationSettings.isForegroundNotificationDisabled()) {
            return;
        }
        Intent intent = new Intent(context, notificationSettings.getCallbackActivity());
        intent.putExtra("message", message.getBundle());
        intent.addFlags(notificationSettings.getIntentFlags());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)notificationSettings.getPendingIntentFlags());
        String title = StringUtils.isNotBlank(message.getTitle()) ? message.getTitle() : notificationSettings.getDefaultTitle();
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context).setDefaults(notificationSettings.getNotificationDefaults()).setContentTitle((CharSequence)title).setContentText((CharSequence)message.getBody()).setAutoCancel(notificationSettings.isNotificationAutoCancel()).setContentIntent(pendingIntent).setWhen(message.getReceivedTimestamp());
        int icon = StringUtils.isNotBlank(message.getIcon()) ? ResourceLoader.loadResourceByName(context, "drawable", message.getIcon()) : notificationSettings.getDefaultIcon();
        notificationBuilder.setSmallIcon(icon);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = notificationBuilder.build();
        notificationManager.notify(0, notification);
    }
}

