/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.deliveryreports.MobileApiDeliveryReport;
import org.infobip.mobile.messaging.api.msisdn.MobileApiRegisterMsisdn;
import org.infobip.mobile.messaging.api.registration.MobileApiRegistration;
import org.infobip.mobile.messaging.api.seenstatus.MobileApiSeenStatusReport;
import org.infobip.mobile.messaging.api.support.Generator;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.SystemInformation;

public enum MobileApiResourceProvider {
    INSTANCE;

    private Generator generator;
    private MobileApiRegistration mobileApiRegistration;
    private MobileApiDeliveryReport mobileApiDeliveryReport;
    private MobileApiRegisterMsisdn mobileApiRegisterMsisdn;
    private MobileApiSeenStatusReport mobileApiSeenStatusReport;

    public MobileApiRegistration getMobileApiRegistration(Context context) {
        if (null != this.mobileApiRegistration) {
            return this.mobileApiRegistration;
        }
        this.mobileApiRegistration = (MobileApiRegistration)this.getGenerator(context).create(MobileApiRegistration.class);
        return this.mobileApiRegistration;
    }

    public MobileApiDeliveryReport getMobileApiDeliveryReport(Context context) {
        if (null != this.mobileApiDeliveryReport) {
            return this.mobileApiDeliveryReport;
        }
        this.mobileApiDeliveryReport = (MobileApiDeliveryReport)this.getGenerator(context).create(MobileApiDeliveryReport.class);
        return this.mobileApiDeliveryReport;
    }

    public MobileApiRegisterMsisdn getMobileApiRegisterMsisdn(Context context) {
        if (null != this.mobileApiRegisterMsisdn) {
            return this.mobileApiRegisterMsisdn;
        }
        this.mobileApiRegisterMsisdn = (MobileApiRegisterMsisdn)this.getGenerator(context).create(MobileApiRegisterMsisdn.class);
        return this.mobileApiRegisterMsisdn;
    }

    public MobileApiSeenStatusReport getMobileApiSeenStatusReport(Context context) {
        if (null != this.mobileApiSeenStatusReport) {
            return this.mobileApiSeenStatusReport;
        }
        this.mobileApiSeenStatusReport = (MobileApiSeenStatusReport)this.getGenerator(context).create(MobileApiSeenStatusReport.class);
        return this.mobileApiSeenStatusReport;
    }

    String[] getUserAgentAdditions(Context context) {
        ArrayList<String> userAgentAdditions = new ArrayList<String>();
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO)) {
            userAgentAdditions.add(SystemInformation.getAndroidSystemName());
            userAgentAdditions.add(SystemInformation.getAndroidSystemVersion());
            userAgentAdditions.add(SystemInformation.getAndroidSystemABI());
            userAgentAdditions.add(DeviceInformation.getDeviceModel());
            userAgentAdditions.add(DeviceInformation.getDeviceManufacturer());
            userAgentAdditions.add(SoftwareInformation.getAppName(context));
            userAgentAdditions.add(SoftwareInformation.getAppVersion(context));
        } else {
            String[] emptySystemInfo = new String[]{"", "", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptySystemInfo));
        }
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO)) {
            userAgentAdditions.add(MobileNetworkInformation.getMobileCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileCoutryCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCoutryCode(context));
        } else {
            String[] emptyCarrierInfoAdditions = new String[]{"", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptyCarrierInfoAdditions));
        }
        return userAgentAdditions.toArray(new String[userAgentAdditions.size()]);
    }

    private Generator getGenerator(Context context) {
        if (null != this.generator) {
            return this.generator;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("api.key", MobileMessagingCore.getApplicationCode(context));
        properties.put("library.version", SoftwareInformation.getLibraryVersion());
        this.generator = new Generator.Builder().withBaseUrl(MobileMessagingCore.getInstance(context).getApiUri()).withProperties(properties).withUserAgentAdditions(this.getUserAgentAdditions(context)).build();
        return this.generator;
    }

    public void resetMobileApi() {
        this.generator = null;
        this.mobileApiRegistration = null;
        this.mobileApiSeenStatusReport = null;
        this.mobileApiDeliveryReport = null;
        this.mobileApiRegisterMsisdn = null;
    }
}

