/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.support.ApiException;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.tasks.RegisterMsisdnResult;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
public class RegisterMsisdnTask
extends AsyncTask<Object, Void, RegisterMsisdnResult> {
    private final Context context;

    public RegisterMsisdnTask(Context context) {
        this.context = context;
    }

    protected RegisterMsisdnResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't report msisdn to MobileMessaging API without valid registration!");
            return null;
        }
        long msisdn = mobileMessagingCore.getUnreportedMsisdn();
        try {
            MobileApiResourceProvider.INSTANCE.getMobileApiRegisterMsisdn(this.context).registerMsisdn(mobileMessagingCore.getDeviceApplicationInstanceId(), msisdn);
            return new RegisterMsisdnResult(msisdn);
        }
        catch (ApiException ae) {
            if ("5".equals(ae.getCode())) {
                this.onMsisdnValidationError((Exception)((Object)ae), msisdn);
            } else {
                this.onApiCommunicationError((Exception)((Object)ae));
            }
            return null;
        }
        catch (Exception e) {
            this.onApiCommunicationError(e);
            return null;
        }
    }

    private void onMsisdnValidationError(Exception e, long msisdn) {
        MobileMessagingCore.getInstance(this.context).setLastHttpException(e);
        Log.e((String)"MobileMessaging", (String)"Error syncing MSISDN - did not pass validation!", (Throwable)e);
        this.cancel(true);
        MobileMessagingCore.getInstance(this.context).setMsisdnReported(false);
        Intent registrationError = new Intent(Event.API_PARAMETER_VALIDATION_ERROR.getKey());
        registrationError.putExtra("org.infobip.mobile.messaging.parameter.name", "org.infobip.mobile.messaging.msisdn");
        registrationError.putExtra("org.infobip.mobile.messaging.parameter.value", msisdn);
        registrationError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
        this.context.sendBroadcast(registrationError);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationError);
    }

    private void onApiCommunicationError(Exception e) {
        MobileMessagingCore.getInstance(this.context).setLastHttpException(e);
        Log.e((String)"MobileMessaging", (String)"Error syncing MSISDN!", (Throwable)e);
        this.cancel(true);
        Intent registrationError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
        registrationError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
        this.context.sendBroadcast(registrationError);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationError);
    }
}

