/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.os.Bundle;

@TargetApi(value=12)
public class Message
implements Comparable {
    private final Bundle bundle;

    public Message() {
        this.bundle = new Bundle();
    }

    public Message(Bundle bundle) {
        this.bundle = bundle;
    }

    public static Message create(String messageId, String body) {
        Message message = new Message();
        message.setMessageId(messageId);
        message.setBody(body);
        return message;
    }

    public static Message copyFrom(Bundle source) {
        Message sourceMessage = new Message(source);
        Message message = new Message();
        message.setFrom(sourceMessage.getFrom());
        message.setMessageId(sourceMessage.getMessageId());
        message.setTitle(sourceMessage.getTitle());
        message.setBody(sourceMessage.getBody());
        message.setSound(sourceMessage.getSound());
        message.setIcon(sourceMessage.getIcon());
        message.setSilent(sourceMessage.isSilent());
        message.setData(sourceMessage.getData());
        message.setReceivedTimestamp(sourceMessage.getReceivedTimestamp());
        message.setSeenTimestamp(sourceMessage.getSeenTimestamp());
        return message;
    }

    public String getMessageId() {
        return this.bundle.getString(Data.MESSAGE_ID.getKey(), null);
    }

    public void setMessageId(String messageId) {
        this.bundle.putString(Data.MESSAGE_ID.getKey(), messageId);
    }

    public String getFrom() {
        return this.bundle.getString(Data.FROM.getKey(), null);
    }

    public void setFrom(String from) {
        this.bundle.putString(Data.FROM.getKey(), from);
    }

    public String getSound() {
        return this.bundle.getString(Data.SOUND.getKey(), null);
    }

    public void setSound(String sound) {
        this.bundle.putString(Data.SOUND.getKey(), sound);
    }

    public String getIcon() {
        return this.bundle.getString(Data.ICON.getKey(), null);
    }

    public void setIcon(String icon) {
        this.bundle.putString(Data.ICON.getKey(), icon);
    }

    public String getBody() {
        return this.bundle.getString(Data.BODY.getKey(), null);
    }

    public void setBody(String body) {
        this.bundle.putString(Data.BODY.getKey(), body);
    }

    public String getTitle() {
        return this.bundle.getString(Data.TITLE.getKey(), null);
    }

    public void setTitle(String title) {
        this.bundle.putString(Data.TITLE.getKey(), title);
    }

    public Bundle getData() {
        return this.bundle.getBundle(Data.DATA.getKey());
    }

    public void setData(Bundle data) {
        this.bundle.putBundle(Data.DATA.getKey(), data);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isSilent() {
        return this.bundle.getBoolean(Data.SILENT.getKey(), false);
    }

    public void setSilent(boolean silent) {
        this.bundle.putBoolean(Data.SILENT.getKey(), silent);
    }

    public long getReceivedTimestamp() {
        return this.bundle.getLong(Data.RECEIVED_TIMESTAMP.getKey(), System.currentTimeMillis());
    }

    public void setReceivedTimestamp(long receivedTimestamp) {
        this.bundle.putLong(Data.RECEIVED_TIMESTAMP.getKey(), receivedTimestamp);
    }

    public long getSeenTimestamp() {
        return this.bundle.getLong(Data.SEEN_TIMESTAMP.getKey(), 0L);
    }

    public void setSeenTimestamp(long receivedTimestamp) {
        this.bundle.putLong(Data.SEEN_TIMESTAMP.getKey(), receivedTimestamp);
    }

    public int compareTo(Object another) {
        if (!(another instanceof Message)) {
            return 1;
        }
        Message message = (Message)another;
        return (int)Math.signum(message.getReceivedTimestamp() - this.getReceivedTimestamp());
    }

    private static enum Data {
        MESSAGE_ID("gcm.notification.messageId"),
        TITLE("gcm.notification.title"),
        BODY("gcm.notification.body"),
        SOUND("gcm.notification.sound"),
        ICON("gcm.notification.icon"),
        FROM("from"),
        SILENT("gcm.notification.silent"),
        RECEIVED_TIMESTAMP("received_timestamp"),
        SEEN_TIMESTAMP("seen_timestamp"),
        DATA("data");

        private final String key;

        private Data(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

