/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.util.StringUtils;

class RegistrationTokenHandler {
    private static final String[] TOPICS = new String[]{"global"};

    RegistrationTokenHandler() {
    }

    void handleRegistrationTokenUpdate(Context context) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)context);
            String token = instanceID.getToken(MobileMessagingCore.getInstance(context).getGcmSenderId(), "GCM", null);
            Intent registrationComplete = new Intent(Event.REGISTRATION_ACQUIRED.getKey());
            registrationComplete.putExtra("registrationId", token);
            context.sendBroadcast(registrationComplete);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationComplete);
            this.sendRegistrationToServer(context, token);
            this.subscribeTopics(context, token);
        }
        catch (IOException e) {
            Log.e((String)"MobileMessaging", (String)"Failed to complete token refresh", (Throwable)e);
        }
    }

    private void sendRegistrationToServer(Context context, String token) {
        boolean saveNeeded;
        if (StringUtils.isBlank(token)) {
            return;
        }
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        String infobipRegistrationId = mobileMessagingCore.getDeviceApplicationInstanceId();
        boolean bl = saveNeeded = null == infobipRegistrationId || null == mobileMessagingCore.getRegistrationId() || !token.equals(mobileMessagingCore.getRegistrationId()) || !mobileMessagingCore.isRegistrationIdReported();
        if (!saveNeeded) {
            return;
        }
        mobileMessagingCore.setRegistrationId(token);
        mobileMessagingCore.sync();
    }

    private void subscribeTopics(Context context, String token) throws IOException {
        GcmPubSub pubSub = GcmPubSub.getInstance((Context)context);
        for (String topic : TOPICS) {
            pubSub.subscribe(token, "/topics/" + topic, null);
        }
    }
}

