/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.preference.PreferenceManager;
import android.util.Base64;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.storage.MessageStore;

public class SharedPreferencesMessageStore
implements MessageStore {
    private static final String INFOBIP_MESSAGE_DATA_SET = "org.infobip.mobile.messaging.store.DATA";
    private static final Object LOCK = new Object();

    @Override
    public void save(Context context, Message message) {
        this.addMessage(context, message);
    }

    @Override
    public List<Message> findAll(Context context) {
        return this.findAllMatching(context, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> findAllMatching(Context context, String ... messageIDs) {
        Object object = LOCK;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            Set messageSet = sharedPreferences.getStringSet(INFOBIP_MESSAGE_DATA_SET, new LinkedHashSet());
            List<String> listMessageIDs = Arrays.asList(messageIDs);
            ArrayList<Message> messages = new ArrayList<Message>();
            for (String s : messageSet) {
                Message message = new Message(this.deserialize(s));
                if (!listMessageIDs.isEmpty() && !listMessageIDs.contains(message.getMessageId())) continue;
                messages.add(message);
            }
            Collections.sort(messages);
            return messages;
        }
    }

    @Override
    public void deleteAll(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sharedPreferences.edit().remove(INFOBIP_MESSAGE_DATA_SET).apply();
    }

    @Override
    public long countAll(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Set unreportedMessageIdSet = sharedPreferences.getStringSet(INFOBIP_MESSAGE_DATA_SET, new LinkedHashSet());
        return unreportedMessageIdSet.size();
    }

    @Override
    public List<Message> bind(final Context context) {
        return new AbstractList<Message>(){

            @Override
            public Message get(int location) {
                return SharedPreferencesMessageStore.this.findAll(context).get(location);
            }

            @Override
            public int size() {
                return SharedPreferencesMessageStore.this.findAll(context).size();
            }
        };
    }

    private void addMessage(Context context, final Message message) {
        SetMutator addMessageMutator = new SetMutator(){

            @Override
            void mutate(Set<String> set) {
                for (String serializedBundle : new HashSet<String>(set)) {
                    Message messageInSet = new Message(SharedPreferencesMessageStore.this.deserialize(serializedBundle));
                    if (!messageInSet.getMessageId().equals(message.getMessageId())) continue;
                    set.remove(serializedBundle);
                    break;
                }
                set.add(SharedPreferencesMessageStore.this.serialize(message.getBundle()));
            }
        };
        this.editMessages(context, addMessageMutator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void editMessages(Context context, SetMutator mutator) {
        Object object = LOCK;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            Set messageSet = sharedPreferences.getStringSet(INFOBIP_MESSAGE_DATA_SET, new LinkedHashSet());
            mutator.mutate(messageSet);
            if (messageSet.isEmpty()) {
                sharedPreferences.edit().remove(INFOBIP_MESSAGE_DATA_SET).apply();
                return;
            }
            sharedPreferences.edit().putStringSet(INFOBIP_MESSAGE_DATA_SET, messageSet).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serialize(Bundle in) {
        Parcel parcel = Parcel.obtain();
        try {
            in.writeToParcel(parcel, 0);
            String string = Base64.encodeToString((byte[])parcel.marshall(), (int)0);
            return string;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle deserialize(String serialized) {
        if (serialized == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            byte[] data = Base64.decode((String)serialized, (int)0);
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            Bundle bundle = parcel.readBundle();
            return bundle;
        }
        finally {
            parcel.recycle();
        }
    }

    private abstract class SetMutator {
        private SetMutator() {
        }

        abstract void mutate(Set<String> var1);
    }
}

