/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.List;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.seenstatus.SeenMessages;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.tasks.SeenMessagesReport;
import org.infobip.mobile.messaging.tasks.SeenStatusReportResult;

@TargetApi(value=14)
public class SeenStatusReportTask
extends AsyncTask<Object, Void, SeenStatusReportResult> {
    private final Context context;

    public SeenStatusReportTask(Context context) {
        this.context = context;
    }

    protected SeenStatusReportResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        try {
            SeenMessages seenMessages;
            String[] messageIDs = mobileMessagingCore.getUnreportedSeenMessageIds();
            if (mobileMessagingCore.isMessageStoreEnabled()) {
                List<Message> messages = mobileMessagingCore.getMessageStore().findAllMatching(this.context, messageIDs);
                seenMessages = SeenMessagesReport.fromMessages(messages);
            } else {
                seenMessages = SeenMessagesReport.fromMessageIds(messageIDs);
            }
            MobileApiResourceProvider.INSTANCE.getMobileApiSeenStatusReport(this.context).report(seenMessages);
            mobileMessagingCore.removeUnreportedSeenMessageIds(messageIDs);
            return new SeenStatusReportResult(messageIDs);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error reporting seen status!", (Throwable)e);
            this.cancel(true);
            Intent seenStatusReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            seenStatusReportError.putExtra("org.infobip.mobile.messaging.parameterException", (Serializable)e);
            this.context.sendBroadcast(seenStatusReportError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(seenStatusReportError);
            return null;
        }
    }
}

