/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.registration.RegistrationResponse;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;

@TargetApi(value=14)
public class UpsertRegistrationTask
extends AsyncTask<Object, Void, RegistrationResponse> {
    private final Context context;

    public UpsertRegistrationTask(Context context) {
        this.context = context;
    }

    protected RegistrationResponse doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        try {
            String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
            String registrationId = mobileMessagingCore.getRegistrationId();
            return MobileApiResourceProvider.INSTANCE.getMobileApiRegistration(this.context).upsert(deviceApplicationInstanceId, registrationId);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error creating registration!", (Throwable)e);
            this.cancel(true);
            Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            registrationSaveError.putExtra("org.infobip.mobile.messaging.parameterException", (Serializable)e);
            this.context.sendBroadcast(registrationSaveError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationSaveError);
            return null;
        }
    }
}

