/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collection;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;

public class ActivityLifecycleMonitor
implements Application.ActivityLifecycleCallbacks {
    private static volatile boolean foreground = false;
    private volatile Activity foregroundActivity = null;

    public ActivityLifecycleMonitor(@NonNull Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public static synchronized boolean isForeground() {
        return foreground;
    }

    @Nullable
    public Activity getForegroundActivity() {
        return this.foregroundActivity;
    }

    private static synchronized void setForeground(Context context, boolean foreground) {
        boolean foregroundBefore = ActivityLifecycleMonitor.foreground;
        ActivityLifecycleMonitor.foreground = foreground;
        if (!foregroundBefore && foreground) {
            ActivityLifecycleMonitor.dispatchAppInForegroundEvent(context);
        }
    }

    private static void dispatchAppInForegroundEvent(Context context) {
        Collection<MessageHandlerModule> messageHandlerModules = MobileMessagingCore.getInstance(context).getMessageHandlerModules();
        if (messageHandlerModules == null) {
            return;
        }
        for (MessageHandlerModule module : messageHandlerModules) {
            if (module == null || MobileMessagingCore.getApplicationCode(context) == null) continue;
            module.applicationInForeground();
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.foregroundActivity = activity;
        ActivityLifecycleMonitor.setForeground((Context)activity, true);
    }

    public void onActivityPaused(Activity activity) {
        this.foregroundActivity = null;
        ActivityLifecycleMonitor.setForeground(null, false);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

