/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.support.v4.content.LocalBroadcastManager;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.LocalEvent;
import org.infobip.mobile.messaging.MobileMessagingConnectivityReceiver;
import org.infobip.mobile.messaging.MobileMessagingSynchronizationReceiver;
import org.infobip.mobile.messaging.platform.MobileMessagingJobService;

public class ComponentUtil {
    public static void setState(Context context, boolean enabled, Class componentClass) {
        int state = enabled ? 1 : 2;
        ComponentName componentName = new ComponentName(context, componentClass);
        try {
            context.getPackageManager().setComponentEnabledSetting(componentName, state, 1);
        }
        catch (Exception e) {
            throw new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_COMPONENT, componentClass.getCanonicalName());
        }
    }

    public static void setSyncronizationReceiverStateEnabled(Context context, MobileMessagingSynchronizationReceiver syncReceiver, boolean enabled) {
        if (enabled) {
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)syncReceiver, new IntentFilter(LocalEvent.APPLICATION_FOREGROUND.getKey()));
        } else {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)syncReceiver);
        }
    }

    public static void setConnectivityComponentsStateEnabled(Context context, boolean enabled) {
        if (Build.VERSION.SDK_INT < 24) {
            ComponentUtil.setState(context, enabled, MobileMessagingConnectivityReceiver.class);
        } else {
            ComponentUtil.setState(context, enabled, MobileMessagingJobService.class);
        }
    }
}

