/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileNetworkInformation {
    private MobileNetworkInformation() {
    }

    public static String getMobileCarrierName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return telephonyManager.getNetworkOperatorName();
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String getMobileCountryCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return MobileNetworkInformation.extractMCC(telephonyManager.getNetworkOperator());
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String getMobileNetworkCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return MobileNetworkInformation.extractMNC(telephonyManager.getNetworkOperator());
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String getSIMCarrierName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return telephonyManager.getSimOperatorName();
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String getSIMCountryCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return MobileNetworkInformation.extractMCC(telephonyManager.getSimOperator());
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String getSIMNetworkCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            try {
                return MobileNetworkInformation.extractMNC(telephonyManager.getSimOperator());
            }
            catch (SecurityException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    private static String extractMCC(String operator) {
        if (StringUtils.isNotBlank(operator) && operator.length() >= 3) {
            return operator.substring(0, 3);
        }
        return "unknown";
    }

    private static String extractMNC(String operator) {
        if (StringUtils.isNotBlank(operator) && operator.length() >= 3) {
            return operator.substring(3);
        }
        return "unknown";
    }

    public static boolean isNetworkAvailableSafely(Context context) {
        Boolean isNetworkAvailable = MobileNetworkInformation.isNetworkAvailable(context);
        return isNetworkAvailable == null || isNetworkAvailable != false;
    }

    public static Boolean isNetworkAvailable(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") != 0 || manager == null) {
            return null;
        }
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED;
    }
}

