/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;

public class MobileMessagingConnectivityReceiver
extends BroadcastReceiver {
    private MobileMessagingCore mobileMessagingCore;

    public MobileMessagingConnectivityReceiver() {
    }

    @VisibleForTesting
    public MobileMessagingConnectivityReceiver(MobileMessagingCore mobileMessagingCore) {
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public void onReceive(Context context, Intent intent) {
        if (TextUtils.isEmpty((CharSequence)this.mobileMessagingCore(context).getApplicationCode())) {
            return;
        }
        if (intent == null || !"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            return;
        }
        if (this.isInternetConnected(intent, context)) {
            this.mobileMessagingCore(context).retrySync();
        }
    }

    private boolean isInternetConnected(Intent intent, Context context) {
        Boolean isNetworkAvailable = MobileNetworkInformation.isNetworkAvailable(context);
        return isNetworkAvailable != null && isNetworkAvailable != false || intent.hasExtra("noConnectivity") && !intent.getBooleanExtra("noConnectivity", false);
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }
}

