/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import com.google.android.gms.common.GoogleApiAvailability;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;

public class PlayServicesSupport {
    public static final int DEVICE_NOT_SUPPORTED = -1;
    private static Boolean isPlayServicesAvailable;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public void checkPlayServicesAndTryToAcquireToken(final Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int errorCode = apiAvailability.isGooglePlayServicesAvailable(context);
        isPlayServicesAvailable = errorCode == 0;
        if (errorCode != 0) {
            if (apiAvailability.isUserResolvableError(errorCode)) {
                MobileMessagingLogger.e(InternalSdkError.ERROR_ACCESSING_GCM.get());
            } else {
                errorCode = -1;
                MobileMessagingLogger.e(InternalSdkError.DEVICE_NOT_SUPPORTED.get());
            }
            final int finalErrorCode = errorCode;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent playServicesError = new Intent(Event.GOOGLE_PLAY_SERVICES_ERROR.getKey());
                    playServicesError.putExtra("org.infobip.mobile.messaging.play.services", finalErrorCode);
                    context.sendBroadcast(playServicesError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(playServicesError);
                    PlayServicesSupport.this.handler.removeCallbacksAndMessages(null);
                }
            });
            return;
        }
        Intent intent = new Intent(context, MobileMessagingGcmIntentService.class);
        intent.setAction("org.infobip.mobile.messaging.gcm.INSTANCE_ID");
        MobileMessagingGcmIntentService.enqueueWork(context, intent);
    }

    public static boolean isPlayServicesAvailable(Context context) {
        if (isPlayServicesAvailable != null) {
            return isPlayServicesAvailable;
        }
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        isPlayServicesAvailable = apiAvailability.isGooglePlayServicesAvailable(context) == 0;
        return isPlayServicesAvailable;
    }
}

