/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationException;

public class MRetryPolicy {
    private final Set<Class<? extends Throwable>> errorsToRetryOn = new HashSet<Class<? extends Throwable>>();
    private int maxRetries = 1;
    private int backoffMultiplier = 0;

    private MRetryPolicy() {
        this.errorsToRetryOn.add(BackendCommunicationException.class);
    }

    boolean shouldRetry(Throwable error, int attemptsDone) {
        for (Class<? extends Throwable> cls : this.errorsToRetryOn) {
            if (!cls.isInstance(error) || attemptsDone >= this.maxRetries) continue;
            return true;
        }
        return false;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public Set<Class<? extends Throwable>> getErrorsToRetryOn() {
        return this.errorsToRetryOn;
    }

    public static class Builder {
        private MRetryPolicy retryPolicy = new MRetryPolicy();

        public Builder withMaxRetries(int maxRetries) {
            this.retryPolicy.maxRetries = maxRetries;
            return this;
        }

        public Builder withBackoffMultiplier(int backoffMultiplier) {
            this.retryPolicy.backoffMultiplier = backoffMultiplier;
            return this;
        }

        @SafeVarargs
        public final Builder withRetryOn(Class<? extends Throwable> ... errorsTypes) {
            this.retryPolicy.errorsToRetryOn.clear();
            this.retryPolicy.errorsToRetryOn.addAll(Arrays.asList(errorsTypes));
            return this;
        }

        public MRetryPolicy build() {
            MRetryPolicy policy = this.retryPolicy;
            this.retryPolicy = new MRetryPolicy();
            return policy;
        }
    }
}

