/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import org.infobip.mobile.messaging.ApplicationCodeProvider;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=11)
public abstract class MobileMessaging {
    public static synchronized MobileMessaging getInstance(Context context) {
        return MobileMessagingCore.getInstance(context);
    }

    public abstract void enablePushRegistration();

    public abstract void disablePushRegistration();

    public abstract boolean isPushRegistrationEnabled();

    public abstract void setMessagesDelivered(String ... var1);

    public abstract void setMessagesSeen(String ... var1);

    public abstract MessageStore getMessageStore();

    public abstract void syncUserData(UserData var1);

    public abstract void syncUserData(UserData var1, ResultListener<UserData> var2);

    public abstract void fetchUserData();

    public abstract void fetchUserData(ResultListener<UserData> var1);

    @Nullable
    public abstract UserData getUserData();

    public abstract void logout();

    public abstract void logout(ResultListener var1);

    public abstract void sendMessages(Message ... var1);

    public abstract void sendMessages(ResultListener<Message[]> var1, Message ... var2);

    public abstract void setAsPrimaryDevice(boolean var1, ResultListener<Void> var2);

    public abstract void setAsPrimaryDevice(boolean var1);

    public abstract boolean isPrimaryDevice();

    public abstract void cleanup();

    public abstract String getPushRegistrationId();

    public static final class Builder {
        private final Application application;
        private String gcmSenderId = (String)MobileMessagingProperty.GCM_SENDER_ID.getDefaultValue();
        private String applicationCode = (String)MobileMessagingProperty.APPLICATION_CODE.getDefaultValue();
        private String apiUri = (String)MobileMessagingProperty.API_URI.getDefaultValue();
        private NotificationSettings notificationSettings = null;
        private boolean reportCarrierInfo = true;
        private boolean reportSystemInfo = true;
        private boolean geofencingActivated = false;
        private boolean doMarkSeenOnNotificationTap = true;
        private boolean shouldSaveUserData = true;
        private boolean storeAppCodeOnDisk = true;
        private ApplicationCodeProvider applicationCodeProvider = null;
        private Class<? extends MessageStore> messageStoreClass = (Class)MobileMessagingProperty.MESSAGE_STORE_CLASS.getDefaultValue();

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application object is mandatory!");
            }
            this.application = application;
            this.loadDefaultApiUri((Context)application);
            this.loadGcmSenderId((Context)application);
            this.loadApplicationCode((Context)application);
            this.loadNotificationSettings((Context)application);
        }

        private void loadNotificationSettings(Context context) {
            boolean displayNotificationEnabled = (Boolean)MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED.getDefaultValue();
            if (!displayNotificationEnabled) {
                return;
            }
            this.notificationSettings = new NotificationSettings.Builder(context).build();
        }

        private void loadDefaultApiUri(Context context) {
            String apiUri;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_api_uri");
            if (resource > 0 && StringUtils.isNotBlank(apiUri = context.getResources().getString(resource))) {
                this.apiUri = apiUri;
            }
        }

        private void loadGcmSenderId(Context context) {
            String gcmSenderId;
            int resource = ResourceLoader.loadResourceByName(context, "string", "google_app_id");
            if (resource > 0 && StringUtils.isNotBlank(gcmSenderId = context.getResources().getString(resource))) {
                this.gcmSenderId = gcmSenderId;
            }
        }

        private void loadApplicationCode(Context context) {
            String applicationCode;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_application_code");
            if (resource > 0 && StringUtils.isNotBlank(applicationCode = context.getResources().getString(resource))) {
                this.applicationCode = applicationCode;
            }
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        private void validateApplicationCodeAvailability() {
            if (this.applicationCode != null && this.storeAppCodeOnDisk) {
                return;
            }
            if (this.applicationCodeProvider != null && !this.storeAppCodeOnDisk) {
                return;
            }
            throw new IllegalArgumentException("Application code is not provided to the library, make sure it is available in resources, builder or via app code provider");
        }

        public Builder withGcmSenderId(String gcmSenderId) {
            this.validateWithParam(gcmSenderId);
            this.gcmSenderId = gcmSenderId;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.storeAppCodeOnDisk = true;
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withoutStoringApplicationCode(ApplicationCodeProvider applicationCodeProvider) {
            Exception exception = null;
            try {
                this.application.getClassLoader().loadClass(applicationCodeProvider.getClass().getCanonicalName());
            }
            catch (ClassNotFoundException | NullPointerException e) {
                exception = e;
            }
            if (exception != null || applicationCodeProvider instanceof Activity) {
                throw new IllegalArgumentException("Application code provider should be implemented in a separate class file that implements ApplicationCodeProvider!");
            }
            this.validateWithParam(applicationCodeProvider);
            this.storeAppCodeOnDisk = false;
            this.applicationCodeProvider = applicationCodeProvider;
            return this;
        }

        public Builder withApiUri(String apiUri) {
            this.validateWithParam(apiUri);
            this.apiUri = apiUri;
            return this;
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.validateWithParam(notificationSettings);
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withoutDisplayNotification() {
            this.notificationSettings = null;
            return this;
        }

        public Builder withMessageStore(Class<? extends MessageStore> messageStoreClass) {
            this.validateWithParam(messageStoreClass);
            this.messageStoreClass = messageStoreClass;
            return this;
        }

        public Builder withoutMessageStore() {
            this.messageStoreClass = null;
            return this;
        }

        public Builder withoutCarrierInfo() {
            this.reportCarrierInfo = false;
            return this;
        }

        public Builder withoutSystemInfo() {
            this.reportSystemInfo = false;
            return this;
        }

        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public Builder withMobileNetworkInfoOnAllDevices() {
            return this;
        }

        public Builder withoutMarkingSeenOnNotificationTap() {
            this.doMarkSeenOnNotificationTap = false;
            return this;
        }

        public Builder withoutStoringUserData() {
            this.shouldSaveUserData = false;
            return this;
        }

        public MobileMessaging build() {
            this.validateApplicationCodeAvailability();
            MobileMessagingCore.setApiUri((Context)this.application, this.apiUri);
            MobileMessagingCore.setGcmSenderId((Context)this.application, this.gcmSenderId);
            MobileMessagingCore.setMessageStoreClass((Context)this.application, this.messageStoreClass);
            MobileMessagingCore.setReportCarrierInfo((Context)this.application, this.reportCarrierInfo);
            MobileMessagingCore.setReportSystemInfo((Context)this.application, this.reportSystemInfo);
            MobileMessagingCore.setDoMarkSeenOnNotificationTap((Context)this.application, this.doMarkSeenOnNotificationTap);
            MobileMessagingCore.setShouldSaveUserData((Context)this.application, this.shouldSaveUserData);
            MobileMessagingCore.setShouldSaveAppCode((Context)this.application, this.storeAppCodeOnDisk);
            MobileMessagingCore.Builder mobileMessagingCoreBuilder = new MobileMessagingCore.Builder(this.application).withDisplayNotification(this.notificationSettings);
            if (this.storeAppCodeOnDisk) {
                mobileMessagingCoreBuilder.withApplicationCode(this.applicationCode);
            } else if (this.applicationCodeProvider != null) {
                mobileMessagingCoreBuilder.withApplicationCode(this.applicationCodeProvider);
            }
            return mobileMessagingCoreBuilder.build();
        }
    }

    public static abstract class ResultListener<T> {
        public abstract void onResult(T var1);

        public void onError(MobileMessagingError e) {
        }
    }
}

