/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.infobip.mobile.messaging.ApplicationCodeProvider;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.MobileMessagingSynchronizationReceiver;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.app.ContextHelper;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.PushDatabaseHelperImpl;
import org.infobip.mobile.messaging.dal.sqlite.SqliteDatabaseProvider;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.common.MAsyncTask;
import org.infobip.mobile.messaging.mobile.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.mobile.data.LogoutUserSynchronizer;
import org.infobip.mobile.messaging.mobile.data.SystemDataReporter;
import org.infobip.mobile.messaging.mobile.data.UserDataReporter;
import org.infobip.mobile.messaging.mobile.instance.InstanceSynchronizer;
import org.infobip.mobile.messaging.mobile.messages.MessagesSynchronizer;
import org.infobip.mobile.messaging.mobile.messages.MoMessageSender;
import org.infobip.mobile.messaging.mobile.registration.RegistrationSynchronizer;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReporter;
import org.infobip.mobile.messaging.mobile.version.VersionChecker;
import org.infobip.mobile.messaging.notification.CoreNotificationHandler;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.MobileMessagingJobService;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.MessageStoreWrapper;
import org.infobip.mobile.messaging.storage.MessageStoreWrapperImpl;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.ComponentUtil;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;
import org.infobip.mobile.messaging.util.ModuleLoader;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class MobileMessagingCore
extends MobileMessaging
implements InstanceSynchronizer.ServerListener {
    private static final int MESSAGE_ID_PARAMETER_LIMIT = 100;
    private static final long MESSAGE_EXPIRY_TIME = TimeUnit.DAYS.toMillis(7L);
    public static final String MM_DEFAULT_HIGH_PRIORITY_CHANNEL_ID = "mm_default_channel_high_priority";
    public static final String MM_DEFAULT_CHANNEL_ID = "mm_default_channel";
    protected static MobileMessagingCore instance;
    protected static MobileApiResourceProvider mobileApiResourceProvider;
    static String applicationCode;
    private static Map<String, String> applicationCodeHashMap;
    static ApplicationCodeProvider applicationCodeProvider;
    private static DatabaseHelper databaseHelper;
    private static MobileMessagingSynchronizationReceiver mobileMessagingSynchronizationReceiver;
    private final MobileMessagingStats stats;
    private final ExecutorService registrationAlignedExecutor;
    private final RetryPolicyProvider retryPolicyProvider;
    private final Broadcaster broadcaster;
    private final ModuleLoader moduleLoader;
    private NotificationHandler notificationHandler;
    private RegistrationSynchronizer registrationSynchronizer;
    private MessagesSynchronizer messagesSynchronizer;
    private UserDataReporter userDataReporter;
    private SystemDataReporter systemDataReporter;
    private InstanceSynchronizer instanceSynchronizer;
    private LogoutUserSynchronizer logoutUserSynchronizer;
    private MoMessageSender moMessageSender;
    private SeenStatusReporter seenStatusReporter;
    private VersionChecker versionChecker;
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private MobileNetworkStateListener mobileNetworkStateListener;
    private PlayServicesSupport playServicesSupport;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private MessageStoreWrapper messageStoreWrapper;
    private final Context context;
    private Map<String, MessageHandlerModule> messageHandlerModules;
    private volatile boolean didSyncAtLeastOnce;

    protected MobileMessagingCore(Context context) {
        this(context, new AndroidBroadcaster(context), Executors.newSingleThreadExecutor(), new ModuleLoader(context));
    }

    protected MobileMessagingCore(Context context, Broadcaster broadcaster, ExecutorService registrationAlignedExecutor, ModuleLoader moduleLoader) {
        Application application;
        MobileMessagingLogger.init(context);
        this.context = context;
        this.broadcaster = broadcaster;
        this.registrationAlignedExecutor = registrationAlignedExecutor;
        this.stats = new MobileMessagingStats(context);
        this.retryPolicyProvider = new RetryPolicyProvider(context);
        this.moduleLoader = moduleLoader;
        this.notificationHandler = this.loadNotificationHandler();
        this.messageHandlerModules = this.loadMessageHandlerModules();
        if (mobileMessagingSynchronizationReceiver == null) {
            mobileMessagingSynchronizationReceiver = new MobileMessagingSynchronizationReceiver();
        }
        if ((application = new ContextHelper(context).getApplication()) != null) {
            this.activityLifecycleMonitor = new ActivityLifecycleMonitor(application);
        }
        ComponentUtil.setSyncronizationReceiverStateEnabled(context, mobileMessagingSynchronizationReceiver, true);
        ComponentUtil.setConnectivityComponentsStateEnabled(context, true);
        this.initDefaultChannels();
    }

    private void initDefaultChannels() {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        String channelName = SoftwareInformation.getAppName(this.context);
        NotificationChannel notificationChannel = new NotificationChannel(MM_DEFAULT_CHANNEL_ID, (CharSequence)channelName, 3);
        notificationChannel.enableLights(true);
        notificationChannel.enableVibration(true);
        notificationManager.createNotificationChannel(notificationChannel);
        NotificationSettings notificationSettings = this.getNotificationSettings();
        if (notificationSettings.areHeadsUpNotificationsEnabled()) {
            NotificationChannel highPriorityNotificationChannel = new NotificationChannel(MM_DEFAULT_HIGH_PRIORITY_CHANNEL_ID, (CharSequence)(channelName + " High Priority"), 4);
            highPriorityNotificationChannel.enableLights(true);
            highPriorityNotificationChannel.enableVibration(true);
            notificationManager.createNotificationChannel(highPriorityNotificationChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MobileMessagingCore getInstance(Context context) {
        if (instance != null) return instance;
        Class<MobileMessagingCore> clazz = MobileMessagingCore.class;
        synchronized (MobileMessagingCore.class) {
            if (instance != null) return instance;
            instance = new MobileMessagingCore(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public Collection<MessageHandlerModule> getMessageHandlerModules() {
        return this.messageHandlerModules.values();
    }

    public <T extends MessageHandlerModule> T getMessageHandlerModule(Class<? extends MessageHandlerModule> cls) {
        if (this.messageHandlerModules.containsKey(cls.getName())) {
            return (T)this.messageHandlerModules.get(cls.getName());
        }
        MessageHandlerModule module = this.moduleLoader.createModule(cls);
        if (module != null) {
            module.init(this.context);
            this.messageHandlerModules.put(cls.getName(), module);
        }
        return (T)module;
    }

    private Map<String, MessageHandlerModule> loadMessageHandlerModules() {
        Map<String, MessageHandlerModule> modules = this.moduleLoader.loadModules(MessageHandlerModule.class);
        for (MessageHandlerModule module : modules.values()) {
            module.init(this.context);
        }
        return modules;
    }

    private NotificationHandler loadNotificationHandler() {
        Map<String, NotificationHandler> handlers = this.moduleLoader.loadModules(NotificationHandler.class);
        NotificationHandler handler = !handlers.isEmpty() ? handlers.values().iterator().next() : new CoreNotificationHandler();
        handler.setContext(this.context);
        return handler;
    }

    public static DatabaseHelper getDatabaseHelper(Context context) {
        if (null == databaseHelper) {
            databaseHelper = new PushDatabaseHelperImpl(context.getApplicationContext());
        }
        return databaseHelper;
    }

    public static SqliteDatabaseProvider getDatabaseProvider(Context context) {
        return (SqliteDatabaseProvider)((Object)MobileMessagingCore.getDatabaseHelper(context));
    }

    @Nullable
    public ActivityLifecycleMonitor getActivityLifecycleMonitor() {
        return this.activityLifecycleMonitor;
    }

    public void sync() {
        this.didSyncAtLeastOnce = true;
        if (!MobileNetworkInformation.isNetworkAvailableSafely(this.context)) {
            this.registerForNetworkAvailability();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)MobileMessagingCore.getApplicationCode(this.context))) {
            MobileMessagingLogger.w("Application code is not found, check your setup");
            return;
        }
        this.registrationSynchronizer().sync();
        this.messagesSynchronizer().sync();
        this.moMessageSender().sync();
        this.seenStatusReporter().sync();
        this.userDataReporter().sync(null, this.getUnreportedUserData());
        this.versionChecker().sync();
        this.syncPrimary();
        this.reportSystemData();
    }

    public void retrySync() {
        if (!this.didSyncAtLeastOnce) {
            return;
        }
        this.messagesSynchronizer().sync();
        this.moMessageSender().sync();
        this.seenStatusReporter().sync();
        this.userDataReporter().sync(null, this.getUnreportedUserData());
        this.syncPrimary();
        this.reportSystemData();
    }

    private void syncPrimary() {
        if (StringUtils.isBlank(this.getPushRegistrationId())) {
            MobileMessagingLogger.w("PushRegistrationID is not available yet, will sync primary setting later");
            return;
        }
        Boolean settingToSend = PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Boolean>(){

            @Override
            public Boolean run() {
                if (PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED)) {
                    PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                }
                return null;
            }
        });
        if (settingToSend != null) {
            this.instanceSynchronizer().sendPrimary(settingToSend);
            return;
        }
        this.instanceSynchronizer().sync();
    }

    public void registerForNetworkAvailability() {
        if (Build.VERSION.SDK_INT >= 24) {
            MobileMessagingJobService.registerJobForConnectivityUpdates(this.context);
        }
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Override
    public void enablePushRegistration() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, true);
        this.registrationSynchronizer().updateStatus(true);
    }

    @Override
    public void disablePushRegistration() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, false);
        this.registrationSynchronizer().updateStatus(false);
    }

    @Override
    public String getPushRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    @Override
    public void setAsPrimaryDevice(final boolean isPrimary, final MobileMessaging.ResultListener<Void> listener) {
        if (this.isPrimaryDevice() == isPrimary) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onResult(null);
                    }
                }
            });
            return;
        }
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED, isPrimary);
        this.instanceSynchronizer().sendPrimary(isPrimary, new InstanceSynchronizer.ActionListener(){

            @Override
            public void onPrimarySetSuccess() {
                PreferenceHelper.remove(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                PreferenceHelper.saveBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY, isPrimary);
                if (listener != null) {
                    listener.onResult(null);
                }
            }

            @Override
            public void onPrimarySetError(Throwable error) {
                PreferenceHelper.remove(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                if (listener != null) {
                    listener.onError(MobileMessagingError.createFrom(error));
                }
            }
        });
    }

    @Override
    public void setAsPrimaryDevice(boolean isPrimary) {
        this.setAsPrimaryDevice(isPrimary, null);
    }

    @Override
    public boolean isPrimaryDevice() {
        return PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Boolean>(){

            @Override
            public Boolean run() {
                if (PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED)) {
                    return PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                }
                return PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY);
            }
        });
    }

    @Override
    public void onPrimaryFetchedFromServer(boolean primary) {
        if (this.isPrimaryDevice() == primary) {
            return;
        }
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY, primary);
        this.broadcaster.primarySettingChanged(primary);
    }

    @Override
    public boolean isPushRegistrationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED);
    }

    public String getCloudToken() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID);
    }

    public void setRegistrationId(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID, registrationId);
        this.setRegistrationIdReported(false);
    }

    public String[] getAndRemoveUnreportedMessageIds() {
        return PreferenceHelper.findAndRemoveStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    public void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void addSyncMessagesIds(String ... messageIDs) {
        String[] timestampMessageIdPair = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, timestampMessageIdPair);
    }

    public String[] getSyncMessagesIds() {
        String[] messageIds = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        ArrayList<String> messageIdsArrayList = new ArrayList<String>(Arrays.asList(messageIds));
        HashSet<String> messageIdsToSync = new HashSet<String>(messageIdsArrayList.size() <= 100 ? messageIdsArrayList.size() : 100);
        boolean shouldUpdateMessageIds = false;
        for (int i = 0; i < messageIdsArrayList.size(); ++i) {
            String syncMessage = messageIdsArrayList.get(i);
            String[] messageIdWithTimestamp = syncMessage.split(", ");
            String strTimeMessageReceived = messageIdWithTimestamp[1];
            long timeMessageReceived = Long.valueOf(strTimeMessageReceived);
            long timeInterval = Time.now() - timeMessageReceived;
            if (timeInterval > MESSAGE_EXPIRY_TIME || i >= 100) {
                messageIdsArrayList.remove(i);
                shouldUpdateMessageIds = true;
                continue;
            }
            messageIdsToSync.add(messageIdWithTimestamp[0]);
        }
        if (shouldUpdateMessageIds) {
            String[] messageIdsToUpdate = new String[messageIdsArrayList.size()];
            messageIdsToUpdate = messageIdsArrayList.toArray(messageIdsToUpdate);
            PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
            PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, messageIdsToUpdate);
        }
        return messageIdsToSync.toArray(new String[messageIdsToSync.size()]);
    }

    public String[] getUnreportedSeenMessageIds() {
        String[] ids = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        return this.filterOutGeneratedMessageIds(ids);
    }

    public void updateUnreportedSeenMessageIds(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] reports = PreferenceHelper.findStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
                if (reports.length == 0) {
                    return null;
                }
                for (int i = 0; i < reports.length; ++i) {
                    String[] messageIdAndTimestamp = reports[i].split(", ");
                    String newMessageId = (String)messageIdMap.get(messageIdAndTimestamp[0]);
                    if (newMessageId == null) continue;
                    reports[i] = StringUtils.concat(newMessageId, messageIdAndTimestamp[1], ", ");
                }
                PreferenceHelper.saveStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, reports);
                return null;
            }
        });
    }

    public void updatedGeneratedMessageIDs(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] generatedMessageIds;
                for (String messageId : generatedMessageIds = MobileMessagingCore.this.getGeneratedMessageIds()) {
                    if (messageIdMap.get(messageId) == null) continue;
                    MobileMessagingCore.this.removeGeneratedMessageIds(new String[]{messageId});
                }
                return null;
            }
        });
    }

    public void addGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private String[] getGeneratedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS);
    }

    private void removeGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private void addUnreportedSeenMessageIds(String ... messageIDs) {
        String[] seenMessages = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, seenMessages);
    }

    private String[] concatTimestampToMessageId(String[] messageIDs) {
        ArrayList<String> syncMessages = new ArrayList<String>(messageIDs.length);
        if (messageIDs.length > 0) {
            for (String messageId : messageIDs) {
                if (messageId == null) continue;
                String seenTimestamp = String.valueOf(Time.now());
                syncMessages.add(StringUtils.concat(messageId, seenTimestamp, ", "));
            }
        }
        return syncMessages.toArray(new String[syncMessages.size()]);
    }

    private String[] filterOutGeneratedMessageIds(String[] messageIDs) {
        String[] generatedMessageIDs = this.getGeneratedMessageIds();
        if (generatedMessageIDs.length == 0) {
            return messageIDs;
        }
        List<String> seenIds = this.getSeenMessageIdsFromReports(messageIDs);
        ArrayList<String> filteredSeenReports = new ArrayList<String>(Arrays.asList(messageIDs));
        for (String generatedMessageId : generatedMessageIDs) {
            int idIndex = seenIds.indexOf(generatedMessageId);
            if (idIndex < 0) continue;
            filteredSeenReports.remove(idIndex);
            seenIds.remove(idIndex);
        }
        return filteredSeenReports.toArray(new String[filteredSeenReports.size()]);
    }

    private List<String> getSeenMessageIdsFromReports(String[] reports) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String report : reports) {
            ids.add(this.getSeenMessageIdFromReport(report));
        }
        return ids;
    }

    private String getSeenMessageIdFromReport(String report) {
        String[] reportContents = report.split(", ");
        return reportContents.length > 0 ? reportContents[0] : null;
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    @Override
    public void setMessagesDelivered(String ... messageIds) {
        this.addUnreportedMessageIds(messageIds);
        this.addSyncMessagesIds(messageIds);
        this.sync();
    }

    @Override
    public void setMessagesSeen(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.updateStoredMessagesWithSeenStatus(messageIds);
        this.sync();
    }

    public void setMessagesSeenDontStore(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.sync();
    }

    private void updateStoredMessagesWithSeenStatus(String[] messageIds) {
        if (!this.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = this.getMessageStore();
        List<String> messageIdList = Arrays.asList(messageIds);
        for (Message m : new ArrayList<Message>(messageStore.findAll(this.context))) {
            if (!messageIdList.contains(m.getMessageId())) continue;
            m.setSeenTimestamp(Time.now());
            messageStore.save(this.context, m);
        }
    }

    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    static void setGcmSenderId(Context context, String gcmSenderId) {
        if (StringUtils.isBlank(gcmSenderId)) {
            throw new IllegalArgumentException("gcmSenderId is mandatory! Get one here: https://developers.google.com/mobile/add?platform=android&cntapi=gcm");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.GCM_SENDER_ID, gcmSenderId);
    }

    public static String getGcmSenderId(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.registrationSynchronizer().isRegistrationIdReported();
    }

    private void setRegistrationIdReported(boolean registrationIdReported) {
        if (TextUtils.isEmpty((CharSequence)MobileMessagingCore.getApplicationCode(this.context))) {
            MobileMessagingLogger.w("Application code not found, check your setup");
            return;
        }
        this.registrationSynchronizer().setRegistrationIdReported(registrationIdReported);
    }

    public static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    @Override
    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    public MessageStoreWrapper getMessageStoreWrapper() {
        if (this.messageStoreWrapper == null) {
            this.messageStoreWrapper = new MessageStoreWrapperImpl(this.context, this.getMessageStore());
        }
        return this.messageStoreWrapper;
    }

    public MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Throwable lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (MobileMessagingCore.shouldSaveApplicationCode(this.context)) {
            if (StringUtils.isBlank(applicationCode)) {
                throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
            }
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, "");
    }

    public static String getApplicationCode(Context context) {
        if (MobileMessagingCore.shouldSaveApplicationCode(context)) {
            applicationCode = PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
            return applicationCode;
        }
        if (applicationCode != null) {
            return applicationCode;
        }
        if (applicationCodeProvider != null) {
            applicationCode = applicationCodeProvider.resolve();
            return applicationCode;
        }
        String appCodeProviderCanonicalClassName = MobileMessagingCore.getApplicationCodeProviderClassName(context);
        try {
            Class<?> c = Class.forName(appCodeProviderCanonicalClassName);
            Object applicationCodeProvider = c.newInstance();
            Method resolve = ApplicationCodeProvider.class.getMethod("resolve", new Class[0]);
            applicationCode = String.valueOf(resolve.invoke(applicationCodeProvider, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return applicationCode;
    }

    public String getApplicationCode() {
        return MobileMessagingCore.getApplicationCode(this.context);
    }

    public static String getApplicationCodeHash(Context context) {
        return MobileMessagingCore.getApplicationCodeHash(MobileMessagingCore.getApplicationCode(context));
    }

    public static String getApplicationCodeHash(String applicationCode) {
        if (StringUtils.isBlank(applicationCode)) {
            return null;
        }
        if (applicationCodeHashMap != null && applicationCodeHashMap.containsKey(applicationCode)) {
            return applicationCodeHashMap.get(applicationCode);
        }
        String appCodeHash = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)applicationCode))).substring(0, 10);
        applicationCodeHashMap = Collections.singletonMap(applicationCode, appCodeHash);
        return appCodeHash;
    }

    public static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public static void resetApiUri(Context context) {
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, (String)MobileMessagingProperty.API_URI.getDefaultValue());
    }

    public static String getApiUri(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.API_URI);
    }

    static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    static void setDoMarkSeenOnNotificationTap(Context context, boolean doMarkSeenOnNotificationTap) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.MARK_SEEN_ON_NOTIFICATION_TAP, doMarkSeenOnNotificationTap);
    }

    public static void setShouldSaveUserData(Context context, boolean shouldSaveUserData) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK, shouldSaveUserData);
    }

    public boolean shouldSaveUserData() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK.getKey(), true);
    }

    public static void setShouldSaveAppCode(Context context, boolean shouldSaveAppCode) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK, shouldSaveAppCode);
    }

    public static boolean shouldSaveApplicationCode(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK.getKey(), true);
    }

    @Override
    public void cleanup() {
        MobileMessagingCore.cleanup(this.context);
    }

    private static void cleanup(Context context) {
        if (instance != null) {
            for (MessageHandlerModule module : MobileMessagingCore.instance.messageHandlerModules.values()) {
                module.cleanup();
            }
        }
        applicationCode = null;
        if (mobileMessagingSynchronizationReceiver != null) {
            ComponentUtil.setSyncronizationReceiverStateEnabled(context, mobileMessagingSynchronizationReceiver, false);
            mobileMessagingSynchronizationReceiver = null;
        }
        ComponentUtil.setConnectivityComponentsStateEnabled(context, false);
        MobileMessagingCore.resetMobileApi();
        String gcmSenderID = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
        Intent intent = new Intent("org.infobip.mobile.messaging.gcm.token.cleanup", null, context, MobileMessagingGcmIntentService.class);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_SENDER_ID", gcmSenderID);
        MobileMessagingGcmIntentService.enqueueWork(context, intent);
        PreferenceHelper.remove(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
    }

    public static void resetMobileApi() {
        mobileApiResourceProvider = null;
    }

    @Override
    public void syncUserData(UserData userData) {
        this.syncUserData(userData, null);
    }

    @Override
    public void syncUserData(UserData userData, MobileMessaging.ResultListener<UserData> listener) {
        UserData userDataToReport = new UserData();
        if (userData != null) {
            String existingUserId;
            UserData existingData = this.getUnreportedUserData();
            String userId = userData.getExternalUserId();
            String string = existingUserId = existingData != null ? existingData.getExternalUserId() : null;
            if (!StringUtils.isEqual(userId, existingUserId)) {
                PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
                existingData = null;
            }
            userDataToReport = UserData.merge(existingData, userData);
        } else {
            String externalUserId;
            UserData existingUserData = this.getUserData();
            String string = externalUserId = existingUserData != null ? existingUserData.getExternalUserId() : null;
            if (externalUserId != null) {
                userDataToReport.setExternalUserId(externalUserId);
            }
        }
        this.userDataReporter().sync(listener, userDataToReport);
    }

    @Override
    public void fetchUserData() {
        this.fetchUserData(null);
    }

    @Override
    public void fetchUserData(MobileMessaging.ResultListener<UserData> listener) {
        this.syncUserData(null, listener);
    }

    @Override
    @Nullable
    public UserData getUserData() {
        UserData existing = null;
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.USER_DATA)) {
            existing = new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.USER_DATA));
        }
        return UserData.merge(existing, this.getUnreportedUserData());
    }

    @Override
    public void logout() {
        this.logoutUserSynchronizer().sync(null);
    }

    @Override
    public void logout(MobileMessaging.ResultListener listener) {
        this.logoutUserSynchronizer().sync(listener);
    }

    public void userLoggedOut() {
        if (this.messageStore != null) {
            this.messageStore.deleteAll(this.context);
        }
        this.resetUserData();
    }

    @Nullable
    public UserData getUnreportedUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
            return new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA));
        }
        return null;
    }

    public void setUserDataReportedWithError() {
        this.setUserDataReported(null);
    }

    public void setUserDataReported(UserData userData) {
        if (userData != null && this.shouldSaveUserData()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.USER_DATA, userData.toString());
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
    }

    public void resetUserData() {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
    }

    @Override
    public void sendMessages(Message ... messages) {
        this.sendMessages((MobileMessaging.ResultListener<Message[]>)null, messages);
    }

    @Override
    public void sendMessages(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        if (this.isMessageStoreEnabled()) {
            this.getMessageStore().save(this.context, messages);
        }
        this.moMessageSender().send(listener, messages);
    }

    public void sendMessagesDontStore(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        this.moMessageSender().sendDontSave(listener, messages);
    }

    public void sendMessagesWithRetry(Message ... messages) {
        this.moMessageSender().sendWithRetry(messages);
    }

    public void reportSystemData() {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getSDKVersionWithPostfixForSystemData(this.context), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", this.isGeofencingActivated(), SoftwareInformation.areNotificationsEnabled(this.context), reportEnabled && DeviceInformation.isDeviceSecure(this.context));
        Integer hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash.intValue() != data.hashCode()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
        }
        this.systemDataReporter().synchronize();
    }

    boolean isGeofencingActivated() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.GEOFENCING_ACTIVATED.getKey(), false);
    }

    public SystemData getUnreportedSystemData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA)) {
            return SystemData.fromJson(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA));
        }
        return null;
    }

    public void setSystemDataReported() {
        SystemData systemData = this.getUnreportedSystemData();
        if (systemData == null) {
            return;
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH, systemData.hashCode());
    }

    private void setApplicationCodeProviderClassName(ApplicationCodeProvider applicationCodeProvider) {
        MobileMessagingCore.applicationCodeProvider = applicationCodeProvider;
        if (applicationCodeProvider == null) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME, applicationCodeProvider.getClass().getCanonicalName());
    }

    private static String getApplicationCodeProviderClassName(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME);
    }

    public void saveUnreportedUserData(UserData userData) {
        if (this.shouldSaveUserData()) {
            PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA, userData.toString());
        }
    }

    private void runOnUiThread(final Runnable runnable) {
        new MAsyncTask<Void, Void>(){

            public Void run(Void[] voids) {
                return null;
            }

            @Override
            public void after(Void aVoid) {
                runnable.run();
            }
        };
    }

    @NonNull
    private MobileApiResourceProvider mobileApiResourceProvider() {
        if (mobileApiResourceProvider == null) {
            mobileApiResourceProvider = new MobileApiResourceProvider();
        }
        return mobileApiResourceProvider;
    }

    @NonNull
    private MoMessageSender moMessageSender() {
        if (this.moMessageSender == null) {
            this.moMessageSender = new MoMessageSender(this.context, this, this.broadcaster, this.registrationAlignedExecutor, this.stats, this.retryPolicyProvider.DEFAULT(), this.mobileApiResourceProvider().getMobileApiMessages(this.context), this.getMessageStoreWrapper());
        }
        return this.moMessageSender;
    }

    @NonNull
    private UserDataReporter userDataReporter() {
        if (this.userDataReporter == null) {
            this.userDataReporter = new UserDataReporter(this, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider, this.stats, this.mobileApiResourceProvider().getMobileApiData(this.context));
        }
        return this.userDataReporter;
    }

    @NonNull
    private SystemDataReporter systemDataReporter() {
        if (this.systemDataReporter == null) {
            this.systemDataReporter = new SystemDataReporter(this, this.stats, this.retryPolicyProvider.DEFAULT(), this.registrationAlignedExecutor, this.broadcaster, this.mobileApiResourceProvider().getMobileApiData(this.context));
        }
        return this.systemDataReporter;
    }

    @NonNull
    private LogoutUserSynchronizer logoutUserSynchronizer() {
        if (this.logoutUserSynchronizer == null) {
            this.logoutUserSynchronizer = new LogoutUserSynchronizer(this, this.stats, this.retryPolicyProvider.DEFAULT(), this.registrationAlignedExecutor, this.broadcaster, this.mobileApiResourceProvider().getMobileApiData(this.context));
        }
        return this.logoutUserSynchronizer;
    }

    @NonNull
    private MessagesSynchronizer messagesSynchronizer() {
        if (this.messagesSynchronizer == null) {
            MobileMessageHandler mobileMessageHandler = new MobileMessageHandler(this, this.broadcaster, this.getNotificationHandler(), this.getMessageStoreWrapper());
            this.messagesSynchronizer = new MessagesSynchronizer(this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider.DEFAULT(), mobileMessageHandler, this.mobileApiResourceProvider().getMobileApiMessages(this.context));
        }
        return this.messagesSynchronizer;
    }

    @NonNull
    private RegistrationSynchronizer registrationSynchronizer() {
        if (this.registrationSynchronizer == null) {
            this.registrationSynchronizer = new RegistrationSynchronizer(this.context, this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider, this.mobileApiResourceProvider().getMobileApiRegistration(this.context));
        }
        return this.registrationSynchronizer;
    }

    @NonNull
    private SeenStatusReporter seenStatusReporter() {
        if (this.seenStatusReporter == null) {
            this.seenStatusReporter = new SeenStatusReporter(this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.mobileApiResourceProvider().getMobileApiMessages(this.context), new BatchReporter(PreferenceHelper.findLong(this.context, MobileMessagingProperty.BATCH_REPORTING_DELAY)));
        }
        return this.seenStatusReporter;
    }

    @NonNull
    VersionChecker versionChecker() {
        if (this.versionChecker == null) {
            this.versionChecker = new VersionChecker(this.context, this, this.stats, this.mobileApiResourceProvider().getMobileApiVersion(this.context), this.retryPolicyProvider);
        }
        return this.versionChecker;
    }

    @NonNull
    private InstanceSynchronizer instanceSynchronizer() {
        if (this.instanceSynchronizer == null) {
            this.instanceSynchronizer = new InstanceSynchronizer(this, this.registrationAlignedExecutor, this.mobileApiResourceProvider().getMobileApiInstance(this.context), new BatchReporter(PreferenceHelper.findLong(this.context, MobileMessagingProperty.BATCH_REPORTING_DELAY)), this.retryPolicyProvider.DEFAULT());
        }
        return this.instanceSynchronizer;
    }

    public static final class Builder {
        private final Application application;
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private ApplicationCodeProvider applicationCodeProvider;

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application is mandatory!");
            }
            this.application = application;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withApplicationCode(ApplicationCodeProvider applicationCodeProvider) {
            this.validateWithParam(applicationCodeProvider);
            this.applicationCodeProvider = applicationCodeProvider;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MobileMessagingCore build() {
            String existingApplicationCode;
            if (MobileMessagingCore.shouldSaveApplicationCode(this.application.getApplicationContext()) && (existingApplicationCode = MobileMessagingCore.getApplicationCode(this.application.getApplicationContext())) != null && !this.applicationCode.equals(existingApplicationCode)) {
                MobileMessagingCore.cleanup((Context)this.application);
            }
            ComponentUtil.disableFirebaseInstanceIdReceiver((Context)this.application);
            ComponentUtil.verifyManifestComponentsForPush((Context)this.application);
            MobileMessagingCore mobileMessagingCore = new MobileMessagingCore((Context)this.application);
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            mobileMessagingCore.setApplicationCodeProviderClassName(this.applicationCodeProvider);
            mobileMessagingCore.mobileNetworkStateListener = new MobileNetworkStateListener((Context)this.application);
            mobileMessagingCore.playServicesSupport = new PlayServicesSupport();
            mobileMessagingCore.playServicesSupport.checkPlayServicesAndTryToAcquireToken(this.application.getApplicationContext());
            Class<MobileMessagingCore> clazz = MobileMessagingCore.class;
            synchronized (MobileMessagingCore.class) {
                instance = mobileMessagingCore;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return mobileMessagingCore;
            }
        }
    }
}

