/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingJob;
import org.infobip.mobile.messaging.dal.bundle.FCMMessageMapper;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.gcm.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;

public class MobileMessagingGcmIntentService
extends JobIntentService {
    public static final String ACTION_GCM_MESSAGE_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    public static final String ACTION_FCM_MESSAGE_RECEIVE = "com.google.firebase.MESSAGING_EVENT";
    public static final String ACTION_ACQUIRE_INSTANCE_ID = "org.infobip.mobile.messaging.gcm.INSTANCE_ID";
    public static final String ACTION_TOKEN_CLEANUP = "org.infobip.mobile.messaging.gcm.token.cleanup";
    public static final String EXTRA_GCM_SENDER_ID = "org.infobip.mobile.messaging.gcm.GCM_SENDER_ID";
    private final RegistrationTokenHandler registrationTokenHandler = new RegistrationTokenHandler();
    private MobileMessageHandler mobileMessageHandler;

    public static void enqueueWork(Context context, Intent work) {
        MobileMessagingGcmIntentService.enqueueWork((Context)context, MobileMessagingGcmIntentService.class, (int)MobileMessagingJob.getScheduleId(context, 2), (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                Message message = FCMMessageMapper.fromCloudBundle(intent.getExtras());
                MobileMessagingLogger.v("RECEIVED MESSAGE FROM FCM", message);
                this.mobileMessageHandler().handleMessage(message);
                break;
            }
            case "org.infobip.mobile.messaging.gcm.token.cleanup": {
                this.registrationTokenHandler.handleRegistrationTokenCleanup((Context)this, intent.getStringExtra(EXTRA_GCM_SENDER_ID));
                break;
            }
            case "org.infobip.mobile.messaging.gcm.INSTANCE_ID": {
                this.registrationTokenHandler.handleRegistrationTokenUpdate((Context)this);
                break;
            }
            case "com.google.firebase.MESSAGING_EVENT": {
                MobileMessagingLogger.v("Received message event from Firebase SDK, ignoring to avoid duplicate notifications");
            }
        }
    }

    private MobileMessageHandler mobileMessageHandler() {
        if (this.mobileMessageHandler == null) {
            MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance((Context)this);
            NotificationHandler notificationHandler = mobileMessagingCore.getNotificationHandler();
            this.mobileMessageHandler = new MobileMessageHandler(mobileMessagingCore, new AndroidBroadcaster((Context)this), notificationHandler, mobileMessagingCore.getMessageStoreWrapper());
        }
        return this.mobileMessageHandler;
    }
}

