/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.instance;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.instance.Instance;
import org.infobip.mobile.messaging.api.instance.MobileApiInstance;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;

public class InstanceSynchronizer {
    private final ServerListener serverListener;
    private final Executor executor;
    private final MobileApiInstance mobileApiInstance;
    private final BatchReporter batchReporter;
    private final MRetryPolicy retryPolicy;

    public InstanceSynchronizer(ServerListener serverListener, Executor executor, MobileApiInstance mobileApiInstance, BatchReporter batchReporter, MRetryPolicy retryPolicy) {
        this.serverListener = serverListener;
        this.executor = executor;
        this.mobileApiInstance = mobileApiInstance;
        this.batchReporter = batchReporter;
        this.retryPolicy = retryPolicy;
    }

    public void sync() {
        this.batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new MRetryableTask<Void, Boolean>(){

                    public Boolean run(Void[] voids) {
                        MobileMessagingLogger.v("GET PRIMARY >>>");
                        Instance instance = InstanceSynchronizer.this.mobileApiInstance.get();
                        MobileMessagingLogger.v("GET PRIMARY <<<", instance);
                        return instance.getPrimary();
                    }

                    @Override
                    public void error(Throwable error) {
                        MobileMessagingLogger.v("GET PRIMARY ERROR <<<", error);
                    }

                    @Override
                    public void after(Boolean primary) {
                        InstanceSynchronizer.this.serverListener.onPrimaryFetchedFromServer(primary);
                    }
                }.retryWith(InstanceSynchronizer.this.retryPolicy).execute(InstanceSynchronizer.this.executor, (IN[])new Void[0]);
            }
        });
    }

    public void sendPrimary(Boolean primary) {
        this.sendPrimary(primary, null);
    }

    public void sendPrimary(Boolean primary, final ActionListener actionListener) {
        new MRetryableTask<Boolean, Void>(){

            public Void run(Boolean[] params) {
                Instance instance = new Instance(params[0]);
                MobileMessagingLogger.v("UPDATE PRIMARY >>>", instance);
                InstanceSynchronizer.this.mobileApiInstance.update(instance);
                MobileMessagingLogger.v("UPDATE PRIMARY <<<");
                return null;
            }

            @Override
            public void after(Void aVoid) {
                if (actionListener != null) {
                    actionListener.onPrimarySetSuccess();
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("UPDATE PRIMARY ERROR <<<", error);
                if (actionListener != null) {
                    actionListener.onPrimarySetError(error);
                }
            }
        }.retryWith(this.retryPolicy).execute(this.executor, (IN[])new Boolean[]{primary});
    }

    public static interface ActionListener {
        public void onPrimarySetSuccess();

        public void onPrimarySetError(Throwable var1);
    }

    public static interface ServerListener {
        public void onPrimaryFetchedFromServer(boolean var1);
    }
}

