/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import java.util.Collection;
import org.infobip.mobile.messaging.LocalEvent;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;

public class ActivityLifecycleMonitor
implements Application.ActivityLifecycleCallbacks {
    private static volatile boolean foreground = false;
    private static volatile Activity foregroundActivity = null;

    public ActivityLifecycleMonitor(@NonNull Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public static synchronized boolean isForeground() {
        return foreground;
    }

    @Nullable
    public Activity getForegroundActivity() {
        return foregroundActivity;
    }

    private static synchronized void setForeground(Context context, boolean foreground) {
        boolean foregroundBefore = ActivityLifecycleMonitor.foreground;
        ActivityLifecycleMonitor.foreground = foreground;
        if (!foregroundBefore && foreground) {
            ActivityLifecycleMonitor.dispatchEventToCore(context);
            ActivityLifecycleMonitor.dispatchEventToModules(context);
        }
    }

    private static void dispatchEventToModules(Context context) {
        Collection<MessageHandlerModule> messageHandlerModules = MobileMessagingCore.getInstance(context).getMessageHandlerModules();
        if (messageHandlerModules == null) {
            return;
        }
        for (MessageHandlerModule module : messageHandlerModules) {
            if (module == null || MobileMessagingCore.getApplicationCode(context) == null) continue;
            module.applicationInForeground();
        }
    }

    private static void dispatchEventToCore(Context context) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(LocalEvent.APPLICATION_FOREGROUND.getKey()));
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        foregroundActivity = activity;
        ActivityLifecycleMonitor.setForeground((Context)activity, true);
    }

    public void onActivityPaused(Activity activity) {
        foregroundActivity = null;
        ActivityLifecycleMonitor.setForeground(null, false);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

