/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.foreground;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.interactive.inapp.foreground.ForegroundState;
import org.infobip.mobile.messaging.interactive.inapp.foreground.ForegroundStateMonitor;

public class ForegroundStateMonitorImpl
implements ForegroundStateMonitor {
    private final Context context;

    public ForegroundStateMonitorImpl(Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    public ForegroundState isInForeground() {
        return this.isInForeground(MobileMessagingCore.getInstance(this.context));
    }

    @VisibleForTesting
    ForegroundState isInForeground(MobileMessagingCore mobileMessagingCore) {
        ActivityLifecycleMonitor activityLifecycleMonitor = mobileMessagingCore.getActivityLifecycleMonitor();
        if (activityLifecycleMonitor == null) {
            return ForegroundState.background();
        }
        Activity activity = activityLifecycleMonitor.getForegroundActivity();
        if (activity == null) {
            return ForegroundState.background();
        }
        return ForegroundState.foreground(activity);
    }
}

