/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.logging;

import android.content.Context;
import java.util.Arrays;
import org.infobip.mobile.messaging.api.shaded.google.gson.Gson;
import org.infobip.mobile.messaging.api.shaded.google.gson.GsonBuilder;
import org.infobip.mobile.messaging.logging.Level;
import org.infobip.mobile.messaging.logging.LogcatWriter;
import org.infobip.mobile.messaging.logging.Writer;

public final class MobileMessagingLogger {
    public static final String TAG = "MobileMessaging";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static Context context;
    private static Writer writer;
    private static boolean isEnforced;

    public static void init(Context context) {
        MobileMessagingLogger.context = context;
    }

    public static void enforce() {
        isEnforced = true;
    }

    public static void setWriter(Writer logWriter) {
        if (logWriter == null) {
            throw new IllegalArgumentException("Log writer should not be null");
        }
        writer = logWriter;
    }

    public static boolean loggingEnabled() {
        boolean isDebuggable = context != null && 0 != (MobileMessagingLogger.context.getApplicationInfo().flags & 2);
        return isDebuggable || isEnforced;
    }

    public static void v(String tag, String msg) {
        MobileMessagingLogger.log(Level.VERBOSE, tag, msg, null);
    }

    public static void v(String msg) {
        MobileMessagingLogger.v(TAG, msg);
    }

    public static void v(String msg, Object o) {
        MobileMessagingLogger.log(Level.VERBOSE, TAG, msg, o);
    }

    public static void v(String msg, Object o, Object ... os) {
        MobileMessagingLogger.log(Level.VERBOSE, TAG, msg, Arrays.asList(o, os));
    }

    public static void v(String tag, String msg, Throwable tr) {
        MobileMessagingLogger.log(Level.VERBOSE, tag, msg, tr);
    }

    public static void v(String msg, Throwable tr) {
        MobileMessagingLogger.v(TAG, msg, tr);
    }

    public static void d(String tag, String msg) {
        MobileMessagingLogger.log(Level.DEBUG, tag, msg, null);
    }

    public static void d(String msg) {
        MobileMessagingLogger.d(TAG, msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        MobileMessagingLogger.log(Level.DEBUG, tag, msg, tr);
    }

    public static void d(String msg, Throwable tr) {
        MobileMessagingLogger.d(TAG, msg, tr);
    }

    public static void i(String tag, String msg) {
        MobileMessagingLogger.log(Level.INFO, tag, msg, null);
    }

    public static void i(String msg) {
        MobileMessagingLogger.i(TAG, msg);
    }

    public static void i(String tag, String msg, Throwable tr) {
        MobileMessagingLogger.log(Level.INFO, tag, msg, tr);
    }

    public static void i(String msg, Throwable tr) {
        MobileMessagingLogger.i(TAG, msg, tr);
    }

    public static void w(String tag, String msg) {
        MobileMessagingLogger.log(Level.WARN, tag, msg, null);
    }

    public static void w(String msg) {
        MobileMessagingLogger.w(TAG, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        MobileMessagingLogger.log(Level.WARN, tag, msg, tr);
    }

    public static void w(String msg, Throwable tr) {
        MobileMessagingLogger.w(TAG, msg, tr);
    }

    public static void e(String tag, String msg) {
        MobileMessagingLogger.log(Level.ERROR, tag, msg, null);
    }

    public static void e(String msg) {
        MobileMessagingLogger.e(TAG, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        MobileMessagingLogger.log(Level.ERROR, tag, msg, tr);
    }

    public static void e(String msg, Throwable tr) {
        MobileMessagingLogger.e(TAG, msg, tr);
    }

    public static String objectToPrettyString(Object o) {
        if (!MobileMessagingLogger.loggingEnabled()) {
            return "";
        }
        return gson.toJson(o);
    }

    private static void log(Level level, String tag, String msg, Object o) {
        if (MobileMessagingLogger.loggingEnabled() || level == Level.ERROR) {
            MobileMessagingLogger.log(level, tag, msg + "\n" + MobileMessagingLogger.objectToPrettyString(o), null);
        }
    }

    private static void log(Level level, String tag, String msg, Throwable tr) {
        if (MobileMessagingLogger.loggingEnabled() || level == Level.ERROR) {
            writer.write(level, tag, msg, tr);
        }
    }

    static {
        writer = new LogcatWriter();
        isEnforced = false;
    }
}

