/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile;

import org.infobip.mobile.messaging.mobile.MobileMessagingError;

public enum InternalSdkError {
    ERROR_SAVING_MESSAGE("20000", "Error saving message"),
    ERROR_ACCESSING_PLAY_SERVICES("20001", "Error accessing play services, use provided 'googleErrorCode' with 'GoogleApiAvailability.getErrorDialog()' (https://developers.google.com/android/reference/com/google/android/gms/common/GoogleApiAvailability.html)"),
    ERROR_TOKEN_REFRESH("20002", "Failed to complete token refresh"),
    ERROR_GCM_TOKEN_CLEANUP("20003", "Failed to complete GCM token cleanup"),
    ERROR_EMPTY_SYSTEM_DATA("20004", "System data is empty, cannot report"),
    DEVICE_NOT_SUPPORTED("20005", "Device is not supported"),
    NO_VALID_REGISTRATION("20006", "There is no valid registration"),
    LOGOUT_IN_PROGRESS("20007", "Logout is currently in progress");

    private final String code;
    private final String message;

    private InternalSdkError(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String get() {
        return new MobileMessagingError(this.code, this.message).toString();
    }

    public InternalSdkException getException() {
        return new InternalSdkException(this.getError().toString());
    }

    public MobileMessagingError getError() {
        return new MobileMessagingError(this.code, this.message);
    }

    public class InternalSdkException
    extends RuntimeException {
        InternalSdkException(String message) {
            super(message);
        }
    }
}

