/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.data.MobileApiData;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.data.LogoutActionListener;
import org.infobip.mobile.messaging.mobile.data.LogoutServerListener;

public class LogoutUserSynchronizer {
    private final MobileApiData mobileApiData;
    private final Executor executor;
    private final BatchReporter batchReporter;
    private final MRetryPolicy policy;
    private final LogoutServerListener serverListener;

    public LogoutUserSynchronizer(MobileApiData mobileApiData, MRetryPolicy policy, Executor executor, BatchReporter batchReporter, LogoutServerListener serverListener) {
        this.executor = executor;
        this.batchReporter = batchReporter;
        this.policy = policy;
        this.mobileApiData = mobileApiData;
        this.serverListener = serverListener;
    }

    public void logout() {
        this.batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new LogoutTask(){

                    @Override
                    public void before() {
                        LogoutUserSynchronizer.this.serverListener.onServerLogoutStarted();
                    }

                    @Override
                    public void error(Throwable error) {
                        MobileMessagingLogger.v("LOGOUT USER ERROR <<<", error);
                        LogoutUserSynchronizer.this.serverListener.onServerLogoutFailed(error);
                    }

                    @Override
                    public void after(Void aVoid) {
                        LogoutUserSynchronizer.this.serverListener.onServerLogoutCompleted();
                    }
                }.retryWith(LogoutUserSynchronizer.this.policy).execute(LogoutUserSynchronizer.this.executor, (IN[])new Void[0]);
            }
        });
    }

    public void logout(final LogoutActionListener actionListener) {
        new LogoutTask(){

            @Override
            public void after(Void objects) {
                if (actionListener != null) {
                    actionListener.onUserInitiatedLogoutCompleted();
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("LOGOUT USER ERROR <<<", error);
                if (actionListener != null) {
                    actionListener.onUserInitiatedLogoutFailed(error);
                }
            }
        }.retryWith(this.policy).execute(this.executor, (IN[])new Void[0]);
    }

    private class LogoutTask
    extends MRetryableTask<Void, Void> {
        private LogoutTask() {
        }

        public Void run(Void[] voids) {
            MobileMessagingLogger.v("LOGOUT USER >>>");
            LogoutUserSynchronizer.this.mobileApiData.logoutUser();
            MobileMessagingLogger.v("LOGOUT USER <<<");
            return null;
        }
    }
}

