/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.messages.MessageResponse;
import org.infobip.mobile.messaging.dal.json.InternalDataMapper;
import org.infobip.mobile.messaging.platform.Time;
import org.json.JSONException;
import org.json.JSONObject;

class MessagesMapper {
    MessagesMapper() {
    }

    static List<Message> mapResponseToMessages(List<MessageResponse> payloads) {
        if (payloads == null) {
            return Collections.emptyList();
        }
        ArrayList<Message> messages = new ArrayList<Message>(payloads.size());
        for (MessageResponse payload : payloads) {
            if (payload == null) continue;
            Message message = MessagesMapper.responseToMessage(payload);
            messages.add(message);
        }
        return messages;
    }

    private static Message responseToMessage(MessageResponse response) {
        JSONObject customPayload = null;
        try {
            customPayload = response.getCustomPayload() != null ? new JSONObject(response.getCustomPayload()) : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Message message = new Message(response.getMessageId(), response.getTitle(), response.getBody(), response.getSound(), !"false".equals(response.getVibrate()), null, "true".equals(response.getSilent()), response.getCategory(), null, Time.now(), 0L, InternalDataMapper.getInternalDataSendDateTime(response.getInternalData()), customPayload, response.getInternalData(), null, Message.Status.UNKNOWN, null, InternalDataMapper.getInternalDataContentUrl(response.getInternalData()));
        InternalDataMapper.updateMessageWithInternalData(message, response.getInternalData());
        return message;
    }
}

