/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.notification.NotificationTapReceiver;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

public class BaseNotificationHandler {
    private static final int DEFAULT_NOTIFICATION_ID = 0;
    private final Context context;

    public BaseNotificationHandler(Context context) {
        this.context = context;
    }

    public void cancelAllNotifications() {
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (notificationManager == null) {
            MobileMessagingLogger.e("Unable to get notification manager and cancel notifications");
            return;
        }
        notificationManager.cancelAll();
    }

    public void displayNotification(NotificationCompat.Builder builder, Message message, int notificationId) {
        if (builder == null) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
            if (notificationManager == null) {
                MobileMessagingLogger.e("Unable to get notification manager and display notification");
                return;
            }
            Notification notification = builder.build();
            MobileMessagingLogger.v("NOTIFY FOR MESSAGE", message);
            notificationManager.notify(notificationId, notification);
        }
        catch (SecurityException se) {
            MobileMessagingLogger.e("Unable to vibrate", new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.VIBRATE"));
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)se));
        }
    }

    public NotificationCompat.Builder createNotificationCompatBuilder(Message message) {
        NotificationSettings notificationSettings = this.notificationSettings(message);
        if (notificationSettings == null) {
            return null;
        }
        String title = StringUtils.isNotBlank(message.getTitle()) ? message.getTitle() : notificationSettings.getDefaultTitle();
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this.context, this.getChannelIdForNotification(notificationSettings)).setContentTitle((CharSequence)title).setContentText((CharSequence)message.getBody()).setAutoCancel(notificationSettings.isNotificationAutoCancel()).setContentIntent(this.createTapPendingIntent(notificationSettings, message)).setWhen(message.getReceivedTimestamp());
        this.setNotificationStyle(notificationBuilder, message, title);
        this.setNotificationSoundAndVibrate(notificationBuilder, message);
        this.setNotificationIcon(notificationBuilder, message);
        this.setPriorityForHeadsupNotification(notificationBuilder, notificationSettings);
        return notificationBuilder;
    }

    private void setNotificationStyle(NotificationCompat.Builder notificationBuilder, Message message, String title) {
        String contentUrl = message.getContentUrl();
        Bitmap notificationPicture = this.fetchNotificationPicture(contentUrl);
        if (notificationPicture == null) {
            notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message.getBody()).setBigContentTitle((CharSequence)title));
            return;
        }
        notificationBuilder.setLargeIcon(notificationPicture);
        notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(notificationPicture).bigLargeIcon(null).setBigContentTitle((CharSequence)title).setSummaryText((CharSequence)message.getBody()));
    }

    @Nullable
    private static Bitmap downloadBitmap(@NonNull String contentUrl) {
        try {
            URL url = new URL(contentUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
            input.close();
            return BaseNotificationHandler.validateBitmap(bitmap);
        }
        catch (Exception e) {
            MobileMessagingLogger.e(e.getMessage());
            return null;
        }
    }

    @Nullable
    private static Bitmap validateBitmap(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        if (bitmap.getWidth() == 0 || bitmap.getHeight() == 0 || BaseNotificationHandler.isBitmapEmpty(bitmap)) {
            MobileMessagingLogger.e("Got empty or malformed Bitmap, ignoring it");
            return null;
        }
        return bitmap;
    }

    private static boolean isBitmapEmpty(@NonNull Bitmap bitmap) {
        return (Build.VERSION.SDK_INT >= 19 ? bitmap.getAllocationByteCount() : bitmap.getByteCount()) == 0;
    }

    @Nullable
    @VisibleForTesting
    Bitmap fetchNotificationPicture(String contentUrl) {
        if (contentUrl == null) {
            return null;
        }
        int maxRetries = PreferenceHelper.findInt(this.context, MobileMessagingProperty.DEFAULT_MAX_RETRY_COUNT);
        for (int i = 0; i < maxRetries; ++i) {
            Bitmap bitmap = BaseNotificationHandler.downloadBitmap(contentUrl);
            if (bitmap == null) continue;
            return bitmap;
        }
        return null;
    }

    @NonNull
    private PendingIntent createTapPendingIntent(NotificationSettings notificationSettings, Message message) {
        Intent intent = new Intent(this.context, NotificationTapReceiver.class);
        intent.setAction(message.getMessageId());
        intent.putExtra("org.infobip.mobile.messaging.message", MessageBundleMapper.messageToBundle(message));
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)notificationSettings.getPendingIntentFlags());
    }

    private NotificationSettings notificationSettings(Message message) {
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(this.context).getNotificationSettings();
        if (null == notificationSettings) {
            return null;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return null;
        }
        if (StringUtils.isBlank(message.getBody())) {
            return null;
        }
        if (ActivityLifecycleMonitor.isForeground() && notificationSettings.isForegroundNotificationDisabled()) {
            return null;
        }
        return notificationSettings;
    }

    private void setNotificationIcon(NotificationCompat.Builder notificationBuilder, Message message) {
        NotificationSettings notificationSettings = this.notificationSettings(message);
        if (notificationSettings == null) {
            return;
        }
        int icon = StringUtils.isNotBlank(message.getIcon()) ? ResourceLoader.loadResourceByName(this.context, "drawable", message.getIcon()) : notificationSettings.getDefaultIcon();
        notificationBuilder.setSmallIcon(icon);
    }

    private void setNotificationSoundAndVibrate(NotificationCompat.Builder notificationBuilder, Message message) {
        int notificationDefaults = -1;
        if (!message.isVibrate()) {
            notificationDefaults &= 0xFFFFFFFD;
        } else if (message.isVibrate() && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.VIBRATE") == -1) {
            notificationDefaults &= 0xFFFFFFFD;
            MobileMessagingLogger.e("Unable to vibrate", new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.VIBRATE"));
        }
        if (!message.isDefaultSound()) {
            notificationDefaults &= 0xFFFFFFFE;
        }
        notificationBuilder.setDefaults(notificationDefaults);
        String sound = message.getSound();
        if (message.isDefaultSound() || StringUtils.isBlank(sound)) {
            return;
        }
        Uri soundUri = Uri.parse((String)("android.resource://" + this.context.getPackageName() + "/raw/" + sound));
        if (soundUri == null) {
            MobileMessagingLogger.e("Cannot create uri for sound:" + sound + " messageId:" + message.getMessageId());
            return;
        }
        notificationBuilder.setSound(soundUri);
    }

    private void setPriorityForHeadsupNotification(NotificationCompat.Builder notificationBuilder, @NonNull NotificationSettings notificationSettings) {
        if (!notificationSettings.areHeadsUpNotificationsEnabled()) {
            return;
        }
        if (ActivityLifecycleMonitor.isForeground()) {
            return;
        }
        notificationBuilder.setPriority(1);
    }

    @NonNull
    private String getChannelIdForNotification(@NonNull NotificationSettings notificationSettings) {
        if (!notificationSettings.areHeadsUpNotificationsEnabled() || ActivityLifecycleMonitor.isForeground()) {
            return "mm_default_channel";
        }
        return "mm_default_channel_high_priority";
    }

    public int getNotificationId(Message message) {
        NotificationSettings settings = this.notificationSettings(message);
        if (settings == null) {
            return 0;
        }
        boolean areMultipleNotificationsEnabled = settings.areMultipleNotificationsEnabled();
        return areMultipleNotificationsEnabled ? message.getMessageId().hashCode() : 0;
    }
}

