/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.platform;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.List;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.platform.Broadcaster;

public class AndroidBroadcaster
implements Broadcaster {
    private final Context context;

    public AndroidBroadcaster(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void messageReceived(@NonNull Message message) {
        this.send(this.prepare(Event.MESSAGE_RECEIVED).putExtras(MessageBundleMapper.messageToBundle(message)));
    }

    @Override
    public void notificationTapped(Message message) {
        this.send(this.prepare(Event.NOTIFICATION_TAPPED).putExtras(MessageBundleMapper.messageToBundle(message)));
    }

    @Override
    public void error(@NonNull MobileMessagingError error) {
        this.send(this.prepare(Event.API_COMMUNICATION_ERROR).putExtra("org.infobip.mobile.messaging.exception", (Serializable)error));
    }

    @Override
    public void registrationAcquired(String cloudToken) {
        this.send(this.prepare(Event.REGISTRATION_ACQUIRED).putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken));
    }

    @Override
    public void registrationCreated(String cloudToken, String pushRegistrationId) {
        this.send(this.prepare(Event.REGISTRATION_CREATED).putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken).putExtra("org.infobip.mobile.messaging.infobip.token", pushRegistrationId));
    }

    @Override
    public void registrationEnabled(String cloudToken, String deviceInstanceId, Boolean registrationEnabled) {
        this.send(this.prepare(Event.PUSH_REGISTRATION_ENABLED).putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken).putExtra("org.infobip.mobile.messaging.infobip.token", deviceInstanceId).putExtra("org.infobip.mobile.messaging.push.registration.enabled", (Serializable)registrationEnabled));
    }

    @Override
    public void deliveryReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent deliveryReportsSent = this.prepare(Event.DELIVERY_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        deliveryReportsSent.putExtras(extras);
        this.send(deliveryReportsSent);
    }

    @Override
    public void seenStatusReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent seenReportsSent = this.prepare(Event.SEEN_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        seenReportsSent.putExtras(extras);
        this.send(seenReportsSent);
    }

    @Override
    public void messagesSent(List<Message> messages) {
        this.send(this.prepare(Event.MESSAGES_SENT).putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", MessageBundleMapper.messagesToBundles(messages)));
    }

    @Override
    public void userDataReported(UserData userData) {
        this.send(this.prepare(Event.USER_DATA_REPORTED).putExtra("org.infobip.mobile.messaging.userdata", userData.toString()));
    }

    @Override
    public void systemDataReported(SystemData systemData) {
        this.send(this.prepare(Event.SYSTEM_DATA_REPORTED).putExtra("org.infobip.mobile.messaging.systemdata", systemData.toString()));
    }

    @Override
    public void userLoggedOut() {
        this.send(this.prepare(Event.USER_LOGGED_OUT));
    }

    @Override
    public void primarySettingChanged(boolean primary) {
        this.send(this.prepare(Event.PRIMARY_CHANGED).putExtra("org.infobip.mobile.messaging.push.primary", primary));
    }

    private void send(Intent intent) {
        this.context.sendBroadcast(intent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    private Intent prepare(Event event) {
        return this.prepare(event.getKey());
    }

    private Intent prepare(String event) {
        return new Intent(event).setPackage(this.context.getPackageName());
    }
}

