/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.DeviceInformation;

public class EncryptUtil {
    private static final String AES_ALGO = "AES/ECB/PKCS5Padding";
    private static Key key = null;

    private static Key getKey(String algorithm, Context context) {
        if (key != null && key.getAlgorithm().equals(algorithm)) {
            return key;
        }
        byte[] keyBytes = DeviceInformation.getDeviceID(context).getBytes();
        key = new SecretKeySpec(keyBytes, algorithm);
        return key;
    }

    public static String encrypt(Context context, String data) {
        if (data == null) {
            return null;
        }
        byte[] encoded = EncryptUtil.encodeAES128(context, data.getBytes());
        return Base64.encodeToString((byte[])encoded, (int)0);
    }

    public static String decrypt(Context context, String encryptedBase64Data) {
        if (encryptedBase64Data == null) {
            return null;
        }
        byte[] encrypted = Base64.decode((String)encryptedBase64Data, (int)0);
        byte[] decrypted = EncryptUtil.decodeAES128(context, encrypted);
        return new String(decrypted);
    }

    private static byte[] encodeAES128(Context context, byte[] data) {
        Key key = EncryptUtil.getKey(AES_ALGO, context);
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    private static byte[] decodeAES128(Context context, byte[] data) {
        Key key = EncryptUtil.getKey(AES_ALGO, context);
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }
}

