/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class SoftwareInformation {
    private static String appVersion = null;
    private static String appName = null;
    private static Integer appIconResourceId = null;
    private static String sdkVersionWithPostfixForSystemData = null;
    private static String sdkVersionWithPostfixForUserAgent = null;
    private static NotificationManagerCompat notificationManagerCompat = null;
    private static Boolean isDebuggableBuild = null;

    private SoftwareInformation() {
    }

    public static String getAppVersion(Context context) {
        if (appVersion != null) {
            return appVersion;
        }
        try {
            appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
        }
        return appVersion;
    }

    public static String getAppName(Context context) {
        if (appName != null) {
            return appName;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            appName = packageManager.getApplicationLabel(applicationInfo).toString();
        }
        catch (Exception e) {
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
        }
        return appName;
    }

    public static int getAppIconResourceId(Context context) {
        if (appIconResourceId != null) {
            return appIconResourceId;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            appIconResourceId = applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appIconResourceId != null ? appIconResourceId : 0;
    }

    public static String getSDKVersionWithPostfixForSystemData(Context context) {
        if (sdkVersionWithPostfixForSystemData != null) {
            return sdkVersionWithPostfixForSystemData;
        }
        sdkVersionWithPostfixForSystemData = SoftwareInformation.getSDKVersion();
        String versionPostfix = PreferenceHelper.findString(context, MobileMessagingProperty.SYSTEM_DATA_VERSION_POSTFIX);
        if (versionPostfix != null) {
            sdkVersionWithPostfixForSystemData = sdkVersionWithPostfixForSystemData + " (" + versionPostfix + ")";
        }
        return sdkVersionWithPostfixForSystemData;
    }

    public static String getSDKVersionWithPostfixForUserAgent(Context context) {
        if (sdkVersionWithPostfixForUserAgent != null) {
            return sdkVersionWithPostfixForUserAgent;
        }
        sdkVersionWithPostfixForUserAgent = SoftwareInformation.getSDKVersion();
        String versionPostfix = PreferenceHelper.findString(context, MobileMessagingProperty.SYSTEM_DATA_VERSION_POSTFIX);
        if (versionPostfix != null) {
            sdkVersionWithPostfixForUserAgent = sdkVersionWithPostfixForUserAgent + "-" + versionPostfix.replace(" ", "-");
        }
        return sdkVersionWithPostfixForUserAgent;
    }

    public static String getSDKVersion() {
        return "1.17.1";
    }

    public static boolean isDebuggableApplicationBuild(Context context) {
        if (isDebuggableBuild != null) {
            return isDebuggableBuild;
        }
        isDebuggableBuild = (context.getApplicationInfo().flags & 2) != 0;
        return isDebuggableBuild;
    }

    public static boolean areNotificationsEnabled(Context context) {
        if (notificationManagerCompat == null) {
            notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        }
        return notificationManagerCompat.areNotificationsEnabled();
    }
}

