/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.util.StringUtils;

public class SystemData {
    private static final JsonSerializer serializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);
    private final String sdkVersion;
    private final String osVersion;
    private final String deviceManufacturer;
    private final String deviceModel;
    private final String applicationVersion;
    private final boolean geofencing;
    private final boolean notificationsEnabled;
    private final boolean deviceSecure;
    private final String osLanguage;

    public SystemData(String sdkVersion, String osVersion, String deviceManufacturer, String deviceModel, String applicationVersion, boolean geofencing, boolean notificationsEnabled, boolean deviceSecure, String osLanguage) {
        this.sdkVersion = sdkVersion;
        this.osVersion = osVersion;
        this.deviceManufacturer = deviceManufacturer;
        this.deviceModel = deviceModel;
        this.applicationVersion = applicationVersion;
        this.geofencing = geofencing;
        this.notificationsEnabled = notificationsEnabled;
        this.deviceSecure = deviceSecure;
        this.osLanguage = osLanguage;
    }

    public static SystemData fromJson(String json) {
        return (SystemData)serializer.deserialize(json, SystemData.class);
    }

    public static SystemData createFrom(Bundle bundle) {
        return (SystemData)serializer.deserialize(bundle.getString("org.infobip.mobile.messaging.systemdata"), SystemData.class);
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public boolean isGeofencing() {
        return this.geofencing;
    }

    public boolean areNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public boolean isDeviceSecure() {
        return this.deviceSecure;
    }

    public String getOsLanguage() {
        return this.osLanguage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = SystemData.appendToHash(result, 31, this.sdkVersion);
        result = SystemData.appendToHash(result, 31, this.osVersion);
        result = SystemData.appendToHash(result, 31, this.deviceManufacturer);
        result = SystemData.appendToHash(result, 31, this.deviceModel);
        result = SystemData.appendToHash(result, 31, this.applicationVersion);
        result = SystemData.appendToHash(result, 31, this.geofencing);
        result = SystemData.appendToHash(result, 31, this.notificationsEnabled);
        result = SystemData.appendToHash(result, 31, this.deviceSecure);
        result = SystemData.appendToHash(result, 31, this.osLanguage);
        return result;
    }

    private static int appendToHash(int result, int prime, Object o) {
        return prime * result + (o == null ? 0 : o.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemData other = (SystemData)o;
        return StringUtils.isEqual(this.sdkVersion, other.sdkVersion) && StringUtils.isEqual(this.osVersion, other.osVersion) && StringUtils.isEqual(this.deviceManufacturer, other.deviceManufacturer) && StringUtils.isEqual(this.deviceModel, other.deviceModel) && StringUtils.isEqual(this.applicationVersion, other.applicationVersion) && this.geofencing == other.geofencing && this.notificationsEnabled == other.notificationsEnabled && this.deviceSecure == other.deviceSecure && StringUtils.isEqual(this.osLanguage, other.osLanguage);
    }

    public String toString() {
        return serializer.serialize((Object)this);
    }
}

